/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.util;

import j2meunit.framework.Test;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.J4METestCase;
import org.j4me.util.MathFunc;
import org.j4me.util.MathFuncTest$1;
import org.j4me.util.MathFuncTest$2;

public class MathFuncTest
extends J4METestCase {
    public MathFuncTest() {
    }

    public MathFuncTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new MathFuncTest("testInverseTrig", new MathFuncTest$1(this)));
        testSuite.addTest(new MathFuncTest("testRound", new MathFuncTest$2(this)));
        return testSuite;
    }

    public void testInverseTrig() {
        double d = MathFunc.atan(Double.NaN);
        this.assertTrue("atan() special case of NaN param", Double.isNaN(d));
        d = MathFunc.atan(-0.0);
        this.assertTrue("atan() special case of 0.0 param", d == -0.0);
        d = MathFunc.atan(-0.0);
        this.assertTrue("atan() special case of 0.0 param", d == -0.0);
        d = MathFunc.atan(1.0);
        this.assertEquals("atan() of 1.0 is PI/4", 0.7853981633974483, d, 1.0E-8);
        d = MathFunc.atan(-1.0);
        this.assertEquals("atan() of -1.0 is -PI/4", -0.7853981633974483, d, 1.0E-8);
        d = MathFunc.atan(-30.5);
        this.assertEquals("atan() of -30.5 is -PI/4", -1.53802118, d, 1.0E-8);
        d = MathFunc.atan2(Double.NaN, Double.NaN);
        this.assertTrue("atan2() special case 1", Double.isNaN(d));
        d = MathFunc.atan2(1.0, Double.NaN);
        this.assertTrue("atan2() special case 2", Double.isNaN(d));
        d = MathFunc.atan2(0.0, 1.0);
        this.assertTrue("atan2() special case 3", d == 0.0);
        d = MathFunc.atan2(1.0, Double.POSITIVE_INFINITY);
        this.assertTrue("atan2() special case 4", d == 0.0);
        d = MathFunc.atan2(-0.0, 1.0);
        this.assertTrue("atan2() special case 5", d == -0.0);
        d = MathFunc.atan2(-1.0, Double.POSITIVE_INFINITY);
        this.assertTrue("atan2() special case 6", d == -0.0);
        d = MathFunc.atan2(0.0, -1.0);
        this.assertEquals("atan2() special case 7", Math.PI, d, 1.0E-8);
        d = MathFunc.atan2(1.0, Double.NEGATIVE_INFINITY);
        this.assertEquals("atan2() special case 8", Math.PI, d, 1.0E-8);
        d = MathFunc.atan2(-1.0, Double.NEGATIVE_INFINITY);
        this.assertEquals("atan2() special case 10", -Math.PI, d, 1.0E-8);
        d = MathFunc.atan2(1.0, 0.0);
        this.assertEquals("atan2() special case 11", 1.5707963267948966, d, 1.0E-8);
        d = MathFunc.atan2(1.0, -0.0);
        this.assertEquals("atan2() special case 12", 1.5707963267948966, d, 1.0E-8);
        d = MathFunc.atan2(Double.POSITIVE_INFINITY, 1.0);
        this.assertEquals("atan2() special case 13", 1.5707963267948966, d, 1.0E-8);
        d = MathFunc.atan2(Double.POSITIVE_INFINITY, -1.0);
        this.assertEquals("atan2() special case 14", 1.5707963267948966, d, 1.0E-8);
        d = MathFunc.atan2(-1.0, 0.0);
        this.assertEquals("atan2() special case 15", -1.5707963267948966, d, 1.0E-8);
        d = MathFunc.atan2(-1.0, -0.0);
        this.assertEquals("atan2() special case 16", -1.5707963267948966, d, 1.0E-8);
        d = MathFunc.atan2(Double.NEGATIVE_INFINITY, 1.0);
        this.assertEquals("atan2() special case 17", -1.5707963267948966, d, 1.0E-8);
        d = MathFunc.atan2(Double.NEGATIVE_INFINITY, -1.0);
        this.assertEquals("atan2() special case 18", -1.5707963267948966, d, 1.0E-8);
        d = MathFunc.atan2(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.assertEquals("atan2() special case 19", 0.7853981633974483, d, 1.0E-8);
        d = MathFunc.atan2(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.assertEquals("atan2() special case 20", 2.356194490192345, d, 1.0E-8);
        d = MathFunc.atan2(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.assertEquals("atan2() special case 21", -0.7853981633974483, d, 1.0E-8);
        d = MathFunc.atan2(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.assertEquals("atan2() special case 22", -2.356194490192345, d, 1.0E-8);
        d = MathFunc.atan2(10.0, -10.0);
        this.assertEquals("atan2() of x=-10.0, y=10.0 is 135.0 degrees", Math.toRadians(135.0), d, 1.0E-8);
        d = MathFunc.atan2(-862.42, 78.5149);
        this.assertEquals("atan2() of y=-862.420000, x=78.514900", -1.4800063943825, d, 1.0E-8);
        d = MathFunc.asin(1.1);
        this.assertTrue("asin() special case of number greater than 1", Double.isNaN(d));
        d = MathFunc.asin(-0.0);
        this.assertTrue("asin() special case of 0", d == -0.0);
        d = MathFunc.asin(0.7);
        this.assertEquals("asin() of 0.7", 0.775397497, d, 1.0E-8);
        d = MathFunc.asin(-0.7);
        this.assertEquals("asin() of -0.7", -0.775397497, d, 1.0E-8);
        d = MathFunc.acos(1.1);
        this.assertTrue("acos() special case of number greater than 1", Double.isNaN(d));
        d = MathFunc.acos(-0.0);
        this.assertEquals("acos() of 0", 1.5707963267948966, d, 1.0E-8);
        d = MathFunc.acos(0.7);
        this.assertEquals("acos() of 0.7", 0.79539883, d, 1.0E-8);
        d = MathFunc.acos(-0.7);
        this.assertEquals("acos() of -0.7", 2.34619382, d, 1.0E-8);
    }

    public void testRound() {
        long l = MathFunc.round(0.0);
        this.assertEquals(0L, l);
        l = MathFunc.round(0.5);
        this.assertEquals(1L, l);
        l = MathFunc.round(1.5);
        this.assertEquals(2L, l);
        l = MathFunc.round(1.49999);
        this.assertEquals(1L, l);
        l = MathFunc.round(13.0002);
        this.assertEquals(13L, l);
        l = MathFunc.round(38532.99);
        this.assertEquals(38533L, l);
        l = MathFunc.round(-0.3);
        this.assertEquals(0L, l);
        l = MathFunc.round(-38332.835);
        this.assertEquals(-38333L, l);
        l = MathFunc.round(0.0f);
        this.assertEquals(0L, l);
        l = MathFunc.round(0.5f);
        this.assertEquals(1L, l);
        l = MathFunc.round(1.5f);
        this.assertEquals(2L, l);
        l = MathFunc.round(1.49999f);
        this.assertEquals(1L, l);
        l = MathFunc.round(13.0002f);
        this.assertEquals(13L, l);
        l = MathFunc.round(38532.99f);
        this.assertEquals(38533L, l);
        l = MathFunc.round(-0.3f);
        this.assertEquals(0L, l);
        l = MathFunc.round(-38332.836f);
        this.assertEquals(-38333L, l);
    }
}

