/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import javax.microedition.lcdui.Font;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;
import org.j4me.ui.components.LabelTest$1;
import org.j4me.ui.components.LabelTest$2;

public class LabelTest
extends TestCase {
    public LabelTest() {
    }

    public LabelTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new LabelTest("testBreakIntoLines", new LabelTest$1(this)));
        testSuite.addTest(new LabelTest("testGetDimensions", new LabelTest$2(this)));
        return testSuite;
    }

    public void testBreakIntoLines() {
        Font font = Font.getFont((int)32, (int)0, (int)0);
        String[] stringArray = Label.breakIntoLines(font, null, 1000);
        this.assertNull("Parsing null should return null", stringArray);
        CharSequence charSequence = "test";
        stringArray = Label.breakIntoLines(font, (String)charSequence, 1000);
        this.assertEquals("Length of single line", 1L, stringArray.length);
        this.assertEquals("Contents of single line", charSequence, stringArray[0]);
        charSequence = "The rain in Spain falls mainly on the plain.";
        stringArray = Label.breakIntoLines(font, (String)charSequence, 100);
        this.assertTrue("Length of multi-line", stringArray.length > 1);
        for (int i = 0; i < stringArray.length; ++i) {
            this.assertTrue("Contents of multi-line contain:  " + stringArray[i], ((String)charSequence).indexOf(stringArray[i]) >= 0);
        }
        String string = "abcdefghijklmnopqrstuvwxyz0123456789";
        stringArray = Label.breakIntoLines(font, string, 100);
        this.assertTrue("Length of multi-line one word", stringArray.length > 1);
        charSequence = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            ((StringBuffer)charSequence).append(stringArray[i]);
        }
        this.assertEquals("Contents of multi-line one word", string, ((StringBuffer)charSequence).toString());
        String string2 = "This is the first paragraph.\nParagraph number 2. Second sentence.";
        stringArray = Label.breakIntoLines(font, string2, 100);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                ++n;
                continue;
            }
            this.assertTrue("Contents of multi-paragraph contain:  " + stringArray[i], string2.indexOf(stringArray[i]) >= 0);
        }
        this.assertEquals("Paragraph separators seen", 1L, n);
    }

    public void testGetDimensions() {
        Theme theme = new Theme();
        Object object = new Label();
        object = ((Component)object).getPreferredSize(theme, 100, 100);
        this.assertEquals("Empty label width", 0L, (long)object[0]);
        this.assertEquals("Empty label height", 0L, (long)object[1]);
        object = new Label();
        ((Label)object).setLabel("Simple");
        int[] nArray = ((Component)object).getPreferredSize(theme, 100, 100);
        object = nArray;
        int n = nArray[0];
        Object object2 = object[1];
        this.assertTrue("Simple label width less than screen", n < 100);
        this.assertTrue("Simple label height less than screen", object2 < 100);
        object = new Label();
        ((Label)object).setLabel("This is a multi-paragraph string.\nFirst sentence of the second paragraph.");
        int[] nArray2 = ((Component)object).getPreferredSize(theme, 100, 100);
        object = nArray2;
        int n2 = nArray2[0];
        Object object3 = object[1];
        this.assertTrue("Multi-paragraph label width less than screen", n2 <= 100);
        this.assertTrue("Multi-paragraph label width greater than simple", n2 > n);
        this.assertTrue("Multi-paragraph label height greater than simple", object3 > object2);
    }
}

