/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import javax.microedition.lcdui.Font;
import org.j4me.bluetoothgps.Coordinates;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.examples.bluetoothgps.CriteriaSelectionScreen;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.bluetoothgps.Pedometer$1;
import org.j4me.examples.bluetoothgps.Pedometer$FieldValue;
import org.j4me.examples.log.LogScreen;
import org.j4me.ui.Dialog;
import org.j4me.ui.Menu;
import org.j4me.ui.components.HorizontalRule;
import org.j4me.ui.components.Label;

public class Pedometer
extends Dialog
implements LocationListener {
    private static final Font a = Font.getFont((int)0, (int)1, (int)16);
    private static final Font b = Font.getFont((int)0, (int)0, (int)0);
    private final LocationModel c;
    private Label d = new Label();
    private Pedometer$FieldValue e = new Pedometer$FieldValue("Traveled (ft)");
    private Pedometer$FieldValue f = new Pedometer$FieldValue("Avg speed (MPH)");
    private Pedometer$FieldValue g = new Pedometer$FieldValue("Latitude");
    private Pedometer$FieldValue h = new Pedometer$FieldValue("Longitude");
    private Pedometer$FieldValue i = new Pedometer$FieldValue("Horizontal accuracy (ft)");
    private Pedometer$FieldValue j = new Pedometer$FieldValue("Altitude (ft)");
    private Pedometer$FieldValue k = new Pedometer$FieldValue("Vertical accuracy (ft)");
    private Pedometer$FieldValue l = new Pedometer$FieldValue("Speed (MPH)");
    private Pedometer$FieldValue m = new Pedometer$FieldValue("Course (deg)");
    private Pedometer$FieldValue n = new Pedometer$FieldValue("Timestamp");
    private float o;
    private long p;
    private QualifiedCoordinates q;

    public Pedometer(LocationModel object) {
        this.c = object;
        this.setMenuText(null, "Menu");
        this.d.setHorizontalAlignment(1);
        this.a(((LocationModel)object).getLocationProvider().getState());
        this.append(this.d);
        this.a("Pedometer");
        this.append(this.e);
        this.append(this.f);
        this.a("Location");
        this.append(this.g);
        this.append(this.h);
        this.append(this.i);
        this.append(new Label());
        this.append(this.j);
        this.append(this.k);
        this.a("Movement");
        this.append(this.l);
        this.append(this.m);
        this.a("Time");
        this.append(this.n);
        object = ((LocationModel)object).getLocationProvider();
        ((LocationProvider)object).setLocationListener(this, 5, -1, -1);
    }

    private void a(String string) {
        this.append(new HorizontalRule());
        Label label = new Label();
        label.setFont(a);
        label.setLabel(string);
        this.append(label);
    }

    protected void acceptNotify() {
        Menu menu = new Menu("Menu", this);
        menu.appendMenuOption(new CriteriaSelectionScreen(this.c));
        menu.appendMenuOption(new Pedometer$1(this));
        menu.appendMenuOption(new LogScreen(this));
        menu.show();
        super.acceptNotify();
    }

    public void locationUpdated(LocationProvider object, Location location) {
        if (location.isValid()) {
            object = location.getQualifiedCoordinates();
            if (this.q == null) {
                this.q = object;
                this.p = System.currentTimeMillis();
            } else {
                this.o += this.q.distance((Coordinates)object);
                float f = this.o / (float)(System.currentTimeMillis() - this.p) * 1000.0f;
                this.q = object;
                float f2 = Pedometer.convertMetersToFeet(this.o);
                this.e.setLabel(f2);
                f = Pedometer.convertMPStoMPH(f);
                this.f.setLabel(f);
            }
            double d = ((Coordinates)object).getLatitude();
            this.g.setLabel(d);
            double d2 = ((Coordinates)object).getLongitude();
            this.h.setLabel(d2);
            float f = ((QualifiedCoordinates)object).getHorizontalAccuracy();
            f = Pedometer.convertMetersToFeet(f);
            this.i.setLabel(f);
            f = ((Coordinates)object).getAltitude();
            f = Pedometer.convertMetersToFeet(f);
            this.j.setLabel(f);
            float f3 = ((QualifiedCoordinates)object).getVerticalAccuracy();
            f3 = Pedometer.convertMetersToFeet(f3);
            this.k.setLabel(f3);
            f3 = location.getSpeed();
            f3 = Pedometer.convertMPStoMPH(f3);
            this.l.setLabel(f3);
            f3 = location.getCourse();
            this.m.setLabel(f3);
            long l = location.getTimestamp();
            this.n.setLabel(l);
            this.repaint();
        }
    }

    public void providerStateChanged(LocationProvider locationProvider, int n) {
        this.a(n);
        this.repaint();
    }

    private void a(int n) {
        switch (n) {
            case 1: {
                this.d.setLabel("Available");
                return;
            }
            case 2: {
                this.d.setLabel("Temporarily unavailable");
                return;
            }
            case 3: {
                this.d.setLabel("Out of service");
            }
        }
    }

    public static float convertMetersToFeet(float f) {
        f *= 1.0936133f;
        return f *= 3.0f;
    }

    public static float convertMPStoMPH(float f) {
        f = Pedometer.convertMetersToFeet(f);
        f *= 3600.0f;
        return f /= 5280.0f;
    }

    static LocationModel a(Pedometer pedometer) {
        return pedometer.c;
    }

    static Font a() {
        return b;
    }
}

