/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import org.j4me.bluetoothgps.Criteria;
import org.j4me.examples.bluetoothgps.FindingGPSDevicesAlert;
import org.j4me.examples.bluetoothgps.InitializingGPSAlert;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.ui.screens.ProgressAlert;
import org.j4me.ui.Dialog;
import org.j4me.ui.components.CheckBox;
import org.j4me.ui.components.RadioButton;
import org.j4me.ui.components.TextBox;

public class CriteriaSelectionScreen
extends Dialog {
    private final LocationModel a;
    private final RadioButton b;
    private final TextBox c;
    private final CheckBox d;
    private final CheckBox e;

    public CriteriaSelectionScreen(LocationModel object) {
        this.a = object;
        this.setTitle("LBS Criteria");
        this.setMenuText(null, "OK");
        this.b = new RadioButton();
        this.b.setLabel("LBS source");
        this.b.append("Device");
        this.b.append("Bluetooth");
        this.append(this.b);
        this.c = new TextBox();
        this.c.setLabel("Horizontal accuracy in meters");
        this.c.setForNumericOnly();
        this.append(this.c);
        this.d = new CheckBox();
        this.d.setLabel("Altitude required");
        this.append(this.d);
        this.e = new CheckBox();
        this.e.setLabel("Speed and course required");
        this.append(this.e);
        object = ((LocationModel)object).getCriteria();
        if (object == null) {
            this.b.setSelectedIndex(0);
            this.c.setString("10");
            return;
        }
        if (((Criteria)object).getRemoteDeviceAddress() == null) {
            this.b.setSelectedIndex(0);
        } else {
            this.b.setSelectedIndex(1);
        }
        this.c.setString(Integer.toString(((Criteria)object).getHorizontalAccuracy()));
        this.d.setChecked(((Criteria)object).isAltitudeRequired());
        this.e.setChecked(((Criteria)object).isSpeedAndCourseRequired());
    }

    protected void acceptNotify() {
        ProgressAlert progressAlert;
        Criteria criteria = new Criteria();
        criteria.setCostAllowed(false);
        criteria.setSpeedAndCourseRequired(this.e.isChecked());
        criteria.setAltitudeRequired(this.d.isChecked());
        criteria.setHorizontalAccuracy(Integer.parseInt(this.c.getString()));
        if (this.b.getSelectedIndex() == 0) {
            criteria.setAllowLocalLBS(true);
            criteria.setRemoteDeviceAddress(null);
            progressAlert = new InitializingGPSAlert(this.a, this);
        } else {
            criteria.setAllowLocalLBS(false);
            progressAlert = new FindingGPSDevicesAlert(this.a, this);
        }
        this.a.setCriteria(criteria);
        progressAlert.show();
        super.acceptNotify();
    }
}

