/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.bluetoothgps.Pedometer;
import org.j4me.examples.ui.screens.ProgressAlert;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;

public class AcquiringLocationAlert
extends ProgressAlert {
    private final LocationModel a;
    private final DeviceScreen b;
    private boolean c = false;

    public AcquiringLocationAlert(LocationModel locationModel, DeviceScreen deviceScreen) {
        super("Acquiring Location...", "The GPS is getting a fix on your location.");
        Object object = locationModel.isGPSOnDevice();
        if (object != null && !((Boolean)object).booleanValue()) {
            object = locationModel.getBluetoothGPSName();
            object = this.getText() + "\n" + "Using device:  " + (String)object;
            this.setText((String)object);
        }
        this.a = locationModel;
        this.b = deviceScreen;
    }

    public void onCancel() {
        Log.debug("Canceling waiting for GPS fix.");
        this.b.show();
    }

    public void cancel() {
        super.cancel();
        this.c = true;
    }

    protected DeviceScreen doWork() {
        Object object;
        QualifiedCoordinates qualifiedCoordinates = null;
        while (!this.c && qualifiedCoordinates == null) {
            object = LocationProvider.getLastKnownLocation();
            if (object == null || (qualifiedCoordinates = object.getQualifiedCoordinates()) != null) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = new Pedometer(this.a);
        return object;
    }
}

