/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.collections;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.collections.TreeNode;
import org.j4me.collections.TreeNodeTest$1;
import org.j4me.collections.TreeNodeTest$2;
import org.j4me.collections.TreeNodeTest$3;
import org.j4me.collections.TreeNodeTest$4;
import org.j4me.collections.TreeNodeTest$5;
import org.j4me.collections.TreeNodeTest$6;
import org.j4me.collections.TreeNodeTest$7;

public class TreeNodeTest
extends TestCase {
    public TreeNodeTest() {
    }

    public TreeNodeTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new TreeNodeTest("testIllegalOperations", new TreeNodeTest$1(this)));
        testSuite.addTest(new TreeNodeTest("testUserObjects", new TreeNodeTest$2(this)));
        testSuite.addTest(new TreeNodeTest("testRoot", new TreeNodeTest$3(this)));
        testSuite.addTest(new TreeNodeTest("testOneChild", new TreeNodeTest$4(this)));
        testSuite.addTest(new TreeNodeTest("testMultipleChildren", new TreeNodeTest$5(this)));
        testSuite.addTest(new TreeNodeTest("testMultipleLevels", new TreeNodeTest$6(this)));
        testSuite.addTest(new TreeNodeTest("testBigTree", new TreeNodeTest$7(this)));
        return testSuite;
    }

    public void testIllegalOperations() {
        Object object;
        boolean bl = false;
        try {
            object = new TreeNode();
            ((TreeNode)object).add(new TreeNode(), 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        catch (Throwable throwable) {
            object = throwable;
            object = throwable.getClass().getName();
            this.fail("Expected exception 'IllegalArgumentException' and got '" + (String)object + "'.");
        }
        if (!bl) {
            this.fail("Expected exception 'IllegalArgumentException' but no exceptions caught.");
        }
        bl = false;
        try {
            object = new TreeNode();
            ((TreeNode)object).remove(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        catch (Throwable throwable) {
            object = throwable;
            object = throwable.getClass().getName();
            this.fail("Expected exception 'IllegalArgumentException' and got '" + (String)object + "'.");
        }
        if (!bl) {
            this.fail("Expected exception 'IllegalArgumentException' but no exceptions caught.");
        }
    }

    public void testUserObjects() {
        Object object = "This is a test string.\n  It should go in and come out the same.";
        Integer n = new Integer(13);
        TreeNode treeNode = new TreeNode(object);
        Object object2 = treeNode.getUserObject();
        object2 = (String)object2;
        this.assertEquals("The attached string should be the same one as put in.", object, object2);
        treeNode.setUserObject(null);
        object2 = treeNode.getUserObject();
        this.assertNull("No user object should be attached to the node.", object2);
        treeNode.setUserObject(n);
        object2 = treeNode.getUserObject();
        object = (Integer)object2;
        this.assertEquals("The attached Integer should be the same one as put in.", n, object);
    }

    public void testRoot() {
        TreeNode treeNode = new TreeNode();
        int n = treeNode.isRoot();
        this.assertTrue("The node should be the root node.", n != 0);
        n = treeNode.index();
        this.assertEquals("The root node should have an index of -1 since it has no parent.", -1L, n);
        n = treeNode.depth();
        this.assertEquals("The root node should have depth of 0 since it has no parent.", 0L, n);
        TreeNode treeNode2 = treeNode.getParent();
        this.assertNull("The root node should not have a parent node.", treeNode2);
        boolean bl = treeNode.hasChildren();
        this.assertTrue("The root node should not have any children because none have been added.", !bl);
        TreeNode[] treeNodeArray = treeNode.children();
        int n2 = treeNodeArray.length;
        this.assertEquals("The root node should not have any children because none have been added.", 0L, n2);
        treeNode.removeFromParent();
    }

    public void testOneChild() {
        TreeNode treeNode = new TreeNode();
        TreeNode treeNode2 = new TreeNode();
        treeNode.add(treeNode2);
        int n = treeNode2.isRoot();
        this.assertTrue("The node should not be the root node.", n == 0);
        n = treeNode2.index();
        this.assertEquals("The child node should have an index of 0 since it is the only child.", 0L, n);
        n = treeNode2.depth();
        this.assertEquals("The child node should have depth of 1 since it is a first level node.", 1L, n);
        TreeNode treeNode3 = treeNode2.getParent();
        this.assertEquals("The child's parent should be the root node.", treeNode, treeNode3);
        boolean bl = treeNode2.hasChildren();
        this.assertTrue("The child node should not have any children because none have been added.", !bl);
        bl = treeNode.hasChildren();
        this.assertTrue("The root node should now have children.", bl);
        Object object = treeNode2.children();
        int n2 = ((TreeNode[])object).length;
        this.assertEquals("The child node should not have any children because none have been added.", 0L, n2);
        object = treeNode.children();
        n2 = ((TreeNode[])object).length;
        this.assertEquals("The root node should have 1 child.", 1L, n2);
        object = object[0];
        this.assertEquals("The root's child should be child.", treeNode2, object);
        treeNode2.removeFromParent();
        int n3 = treeNode2.isRoot();
        this.assertTrue("The child node should now be the root of its own subtree.", n3 == 1);
        n3 = treeNode2.depth();
        this.assertEquals("The child node should have depth of 0 since it is now the root.", 0L, n3);
        TreeNode treeNode4 = treeNode2.getParent();
        this.assertEquals("The child should not have a parent since it is now the root.", null, treeNode4);
        boolean bl2 = treeNode.hasChildren();
        this.assertTrue("The root node should no longer have any children.", !bl2);
    }

    public void testMultipleChildren() {
        TreeNode treeNode = new TreeNode();
        TreeNode treeNode2 = new TreeNode();
        TreeNode treeNode3 = new TreeNode();
        TreeNode treeNode4 = new TreeNode();
        treeNode.add(treeNode2, 0);
        treeNode.add(treeNode4, 1);
        treeNode.add(treeNode3, 1);
        TreeNode[] treeNodeArray = treeNode.children();
        this.assertEquals("child1 should be the first child.", treeNode2, treeNodeArray[0]);
        this.assertEquals("child2 should be the second child.", treeNode3, treeNodeArray[1]);
        this.assertEquals("child3 should be the third child.", treeNode4, treeNodeArray[2]);
        for (int i = 0; i < treeNodeArray.length; ++i) {
            TreeNode treeNode5 = treeNodeArray[i];
            int n = treeNode5.index();
            this.assertEquals("child" + (i + 1) + " should have an index of " + i, i, n);
            n = treeNode5.isRoot() ? 1 : 0;
            this.assertTrue("child" + (i + 1) + " should not be the root node.", n == 0);
            n = treeNode5.depth();
            this.assertEquals("child" + (i + 1) + " should have depth of 1 since it is a first level node.", 1L, n);
            TreeNode treeNode6 = treeNode5.getParent();
            this.assertEquals("child" + (i + 1) + "'s parent should be the root node.", treeNode, treeNode6);
            boolean bl = treeNode5.hasChildren();
            this.assertTrue("child" + (i + 1) + " should not have any children because none have been added.", !bl);
        }
        TreeNode treeNode7 = treeNode.remove(1);
        this.assertEquals("The removed node should be child2.", treeNode3, treeNode7);
        this.assertEquals("child2 should now have a depth of 0.", 0L, treeNode7.depth());
        treeNodeArray = treeNode.children();
        this.assertEquals("The root should now have 2 children.", 2L, treeNodeArray.length);
        this.assertEquals("child3 should be the second child.", treeNode4, treeNodeArray[1]);
        treeNode.add(treeNode7, 1);
        treeNodeArray = treeNode.children();
        TreeNode treeNode8 = treeNodeArray[1];
        this.assertEquals("The second node should be child2 again.", treeNode3, treeNode8);
        this.assertEquals("child2's parent should be the root again.", treeNode, treeNode3.getParent());
        this.assertEquals("child2's depth should be 1 again.", 1L, treeNode3.depth());
        treeNode.remove(1);
        treeNode.remove(1);
        treeNode2.removeFromParent();
        this.assertTrue("The root should not have any children now.", !treeNode.hasChildren());
    }

    public void testMultipleLevels() {
        TreeNode treeNode = new TreeNode();
        TreeNode treeNode2 = new TreeNode();
        TreeNode treeNode3 = new TreeNode();
        TreeNode treeNode4 = new TreeNode();
        treeNode.add(treeNode2);
        treeNode3.add(treeNode4);
        treeNode2.add(treeNode3);
        this.assertTrue("The root should have 1 child.", treeNode.hasChildren());
        this.assertEquals("The root should have a depth of 0.", 0L, treeNode.depth());
        this.assertEquals("The root should not have a parent.", null, treeNode.getParent());
        this.assertTrue("depth1 should have 1 child.", treeNode2.hasChildren());
        this.assertEquals("depth1 should have a depth of 1.", 1L, treeNode2.depth());
        this.assertEquals("depth1 should have root as its parent.", treeNode, treeNode2.getParent());
        this.assertTrue("depth2 should have 1 child.", treeNode3.hasChildren());
        this.assertEquals("depth2 should have a depth of 2.", 2L, treeNode3.depth());
        this.assertEquals("depth2 should have depth1 as its parent.", treeNode2, treeNode3.getParent());
        this.assertTrue("depth3 should have not have any children.", !treeNode4.hasChildren());
        this.assertEquals("depth3 should have a depth of 3.", 3L, treeNode4.depth());
        this.assertEquals("depth3 should have depth2 as its parent.", treeNode3, treeNode4.getParent());
        treeNode3.removeFromParent();
        this.assertTrue("depth2 should now be a root.", treeNode3.isRoot());
        this.assertEquals("depth2 should now have a depth of 0.", 0L, treeNode3.depth());
        this.assertEquals("depth3 should now have a depth of 1.", 1L, treeNode4.depth());
        this.assertTrue("depth1 should not have any children now.", !treeNode2.hasChildren());
    }

    public void testBigTree() {
        String string = "";
        TreeNode treeNode = new TreeNode();
        TreeNode treeNode2 = new TreeNode(string);
        TreeNode treeNode3 = new TreeNode(string);
        TreeNode treeNode4 = new TreeNode(string);
        TreeNode treeNode5 = new TreeNode(string);
        TreeNode treeNode6 = new TreeNode(string);
        TreeNode treeNode7 = new TreeNode(string);
        TreeNode treeNode8 = new TreeNode(string);
        TreeNode treeNode9 = new TreeNode(string);
        TreeNode treeNode10 = new TreeNode(string);
        TreeNode treeNode11 = new TreeNode(string);
        treeNode.add(treeNode2);
        treeNode.add(treeNode3);
        treeNode.add(treeNode4);
        treeNode3.add(treeNode6);
        treeNode3.add(treeNode5, 0);
        treeNode3.add(treeNode7);
        treeNode4.add(treeNode8);
        treeNode8.add(treeNode10);
        treeNode8.add(treeNode11);
        treeNode4.add(treeNode9);
        this.assertEquals("root should be the parent of d1c0", treeNode, treeNode2.getParent());
        this.assertEquals("root should be the parent of d1c1", treeNode, treeNode3.getParent());
        this.assertEquals("root should be the parent of d1c2", treeNode, treeNode4.getParent());
        this.assertEquals("d1c1 should be the parent of d2c1c0", treeNode3, treeNode5.getParent());
        this.assertEquals("d1c1 should be the parent of d2c1c1", treeNode3, treeNode6.getParent());
        this.assertEquals("d1c1 should be the parent of d2c1c2", treeNode3, treeNode7.getParent());
        this.assertEquals("d1c2 should be the parent of d2c2c0", treeNode4, treeNode8.getParent());
        this.assertEquals("d1c2 should be the parent of d2c2c1", treeNode4, treeNode9.getParent());
        this.assertEquals("d2c2c0 should be the parent of d3c2c0c0", treeNode8, treeNode10.getParent());
        this.assertEquals("d2c2c0 should be the parent of d3c2c0c1", treeNode8, treeNode11.getParent());
        this.assertEquals("root should have a depth of 0", 0L, treeNode.depth());
        this.assertEquals("d1c1 should have a depth of 1", 1L, treeNode3.depth());
        this.assertEquals("d2c2c0 should have a depth of 2", 2L, treeNode8.depth());
        this.assertEquals("d3c2c0c1 should have a depth of 3", 3L, treeNode11.depth());
        treeNode = treeNode.children()[2];
        treeNode = treeNode.children()[0];
        treeNode = treeNode.children()[0];
        this.assertEquals("We should have tranversed the tree to d3c2c0c0.", treeNode10, treeNode);
        this.assertEquals("Should have test data as user object from node d3c2c0c0.", string, treeNode.getUserObject());
    }
}

