/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.collections;

import j2meunit.framework.Test;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.J4METestCase;
import org.j4me.collections.CubbyHole;
import org.j4me.collections.CubbyHoleTest$1;
import org.j4me.collections.CubbyHoleTest$1Consumer;
import org.j4me.collections.CubbyHoleTest$2;

public class CubbyHoleTest
extends J4METestCase {
    public CubbyHoleTest() {
    }

    public CubbyHoleTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new CubbyHoleTest("testBasics", new CubbyHoleTest$1(this)));
        testSuite.addTest(new CubbyHoleTest("testBlocking", new CubbyHoleTest$2(this)));
        return testSuite;
    }

    public void testBasics() {
        try {
            CubbyHole cubbyHole = new CubbyHole();
            boolean bl = cubbyHole.empty();
            this.assertTrue("The cubby hole is empty.", bl);
            Object object = cubbyHole.peek();
            this.assertNull("Nothing comes from peaking into an empty cubby hole.", object);
            Integer n = new Integer(13);
            cubbyHole.set(n);
            boolean bl2 = cubbyHole.empty();
            this.assertFalse("The cubby hole has something in it.", bl2);
            Object object2 = cubbyHole.peek();
            this.assertSame("The cubby hole correctly stored our object.", n, object2);
            object2 = cubbyHole.get();
            this.assertSame("Got the object stored in the cubby.", n, object2);
            boolean bl3 = cubbyHole.empty();
            this.assertTrue("The cubby hole is empty again.", bl3);
            Object object3 = cubbyHole.peek();
            this.assertNull("Nothing comes from peaking into the empty again cubby hole.", object3);
            n = new Integer(1);
            Integer n2 = new Integer(2);
            Integer n3 = new Integer(3);
            object3 = cubbyHole.set(n);
            this.assertNull("Nothing returned from empty cubby hole.", object3);
            object3 = cubbyHole.set(n2);
            this.assertSame("Old data i1 returned from cubby hole.", n, object3);
            object3 = cubbyHole.set(n3);
            this.assertSame("Old data i2 returned from cubby hole.", n2, object3);
            object3 = cubbyHole.get();
            this.assertSame("Newest data is in cubby hole.", n3, object3);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.fail(interruptedException.toString());
            return;
        }
    }

    public void testBlocking() {
        Object object = new CubbyHole();
        CubbyHole cubbyHole = new CubbyHole();
        try {
            Object object2 = new CubbyHoleTest$1Consumer(this, (CubbyHole)object, cubbyHole);
            ((Thread)object2).start();
            Thread.sleep(0L);
            object2 = new Integer(13);
            ((CubbyHole)object).set(object2);
            object = (Integer)cubbyHole.get();
            this.assertSame("Data integrety verified.", object2, object);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.fail(interruptedException.toString());
            return;
        }
    }
}

