/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import j2meunit.framework.Test;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.J4METestCase;
import org.j4me.bluetoothgps.GPSRecord;
import org.j4me.bluetoothgps.NMEAParser;
import org.j4me.bluetoothgps.NMEAParserTest$1;
import org.j4me.bluetoothgps.NMEAParserTest$2;
import org.j4me.bluetoothgps.NMEAParserTest$3;
import org.j4me.bluetoothgps.NMEAParserTest$4;
import org.j4me.bluetoothgps.NMEAParserTest$5;
import org.j4me.bluetoothgps.NMEAParserTest$6;
import org.j4me.bluetoothgps.NMEAParserTest$7;

public class NMEAParserTest
extends J4METestCase {
    public NMEAParserTest() {
    }

    public NMEAParserTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new NMEAParserTest("testByteArrayFinds", new NMEAParserTest$1(this)));
        testSuite.addTest(new NMEAParserTest("testParseCorruptSentence", new NMEAParserTest$2(this)));
        testSuite.addTest(new NMEAParserTest("testThrowAwaySentence", new NMEAParserTest$3(this)));
        testSuite.addTest(new NMEAParserTest("testGPRMC", new NMEAParserTest$4(this)));
        testSuite.addTest(new NMEAParserTest("testGPGGA", new NMEAParserTest$5(this)));
        testSuite.addTest(new NMEAParserTest("testGPGSA", new NMEAParserTest$6(this)));
        testSuite.addTest(new NMEAParserTest("testBatchData", new NMEAParserTest$7(this)));
        return testSuite;
    }

    public void testByteArrayFinds() {
        byte[] byArray = "abcdefghijklmnopqrstuvwxyz".getBytes();
        int n = NMEAParser.indexOf(byArray, (byte)122, 20, byArray.length);
        this.assertEquals("indexOf() should find z last", byArray.length - 1, n);
        n = NMEAParser.indexOf(byArray, (byte)122, 0, byArray.length - 1);
        this.assertEquals("indexOf() should stop before z", -1L, n);
        n = NMEAParser.lastIndexOf(byArray, (byte)122, byArray.length - 1);
        this.assertEquals("lastIndexOf() should find z when starting at the end", byArray.length - 1, n);
        n = NMEAParser.lastIndexOf(byArray, (byte)122, byArray.length - 2);
        this.assertEquals("lastIndexOf() should not find z when starting before it", -1L, n);
    }

    public void testParseCorruptSentence() {
        Object object = "$GPRMC,190350.000,A,3746.0164,N,12226.1176,W,0.45,210.68,031006,,*15\r\n";
        object = "$GPRMC,190350.000,A,3746.0164,N,12226.1176,W,0.45,210.68,031006,,*15\r\n".getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse((byte[])object, ((Object)object).length);
        this.assertEquals("Invalid checksum should have been discarded", 0L, n);
        Object object2 = "GPGGA,190353.000,3746.0164,N,12226.1176,W,1,08,1.0,67.5,M,-25.3,M,,0000*56\r\n";
        object2 = "GPGGA,190353.000,3746.0164,N,12226.1176,W,1,08,1.0,67.5,M,-25.3,M,,0000*56\r\n".getBytes();
        nMEAParser = new NMEAParser();
        int n2 = nMEAParser.parse((byte[])object2, ((Object)object2).length);
        this.assertEquals("No opening '$' should have been discarded", 0L, n2);
        Object object3 = "1171,W,1,08,1.0,68.8,M,-25.3,M,,0000*5C\r\n";
        object3 = "1171,W,1,08,1.0,68.8,M,-25.3,M,,0000*5C\r\n".getBytes();
        nMEAParser = new NMEAParser();
        int n3 = nMEAParser.parse((byte[])object3, ((Object)object3).length);
        this.assertEquals("Partial sentence should have been discarded", 0L, n3);
        Object object4 = "$GPGGA,063606.000,3746.0183,N,12226.1274,W,1,05,2.1,55.1,3,23,16,13,27,25,,,,,,,,4.1,2.1,3.6*37\r\n";
        object4 = "$GPGGA,063606.000,3746.0183,N,12226.1274,W,1,05,2.1,55.1,3,23,16,13,27,25,,,,,,,,4.1,2.1,3.6*37\r\n".getBytes();
        nMEAParser = new NMEAParser();
        int n4 = nMEAParser.parse((byte[])object4, ((Object)object4).length);
        this.assertEquals("Merged sentences should have been discarded", 0L, n4);
    }

    public void testThrowAwaySentence() {
        Object object = "$GPGSV,3,2,09,19,32,069,27,10,25,288,25,03,14,043,30,23,12,143,16*70\r\n";
        object = "$GPGSV,3,2,09,19,32,069,27,10,25,288,25,03,14,043,30,23,12,143,16*70\r\n".getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse((byte[])object, ((Object)object).length);
        this.assertEquals("NMEA sentence should have been discarded", 0L, n);
        Object object2 = "$PSRFTXT,Baud rate: 38400  System clock: 1058.797MHz\r\n";
        object2 = "$PSRFTXT,Baud rate: 38400  System clock: 1058.797MHz\r\n".getBytes();
        nMEAParser = new NMEAParser();
        int n2 = nMEAParser.parse((byte[])object2, ((Object)object2).length);
        this.assertEquals("SiRF sentence should have been discarded", 0L, n2);
    }

    public void testGPRMC() {
        Object object = "$GPRMC,063605.000,A,3746.0188,N,12226.1276,W,0.40,130.67,140207,,*10\r\n";
        object = "$GPRMC,063605.000,A,3746.0188,N,12226.1276,W,0.40,130.67,140207,,*10\r\n".getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse((byte[])object, ((Object)object).length);
        this.assertEquals("GPRMC sentence should have been parsed", 1L, n);
        GPSRecord gPSRecord = nMEAParser.getRecordBuffer();
        this.assertEquals("GPRMC latitude", "3746.0188", gPSRecord.lattitude);
        this.assertEquals("GPRMC latitude direction", 78L, gPSRecord.lattitudeDirection);
        this.assertEquals("GPRMC longitude", "12226.1276", gPSRecord.longitude);
        this.assertEquals("GPRMC longitude direction", 87L, gPSRecord.longitudeDirection);
        this.assertEquals("GPRMC speed", "0.40", gPSRecord.speed);
        this.assertEquals("GPRMC course", "130.67", gPSRecord.course);
    }

    public void testGPGGA() {
        Object object = "$GPGGA,063606.000,3746.0183,N,12226.1274,W,1,05,2.1,55.1,M,-25.3,M,,0000*5C\r\n";
        object = "$GPGGA,063606.000,3746.0183,N,12226.1274,W,1,05,2.1,55.1,M,-25.3,M,,0000*5C\r\n".getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse((byte[])object, ((Object)object).length);
        this.assertEquals("GPGGA sentence should have been parsed", 2L, n);
        GPSRecord gPSRecord = nMEAParser.getRecordBuffer();
        this.assertEquals("GPGGA altitude", "55.1", gPSRecord.altitude);
    }

    public void testGPGSA() {
        Object object = "$GPGSA,A,3,23,16,13,27,25,,,,,,,,4.1,2.1,3.6*37\r\n";
        object = "$GPGSA,A,3,23,16,13,27,25,,,,,,,,4.1,2.1,3.6*37\r\n".getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = nMEAParser.parse((byte[])object, ((Object)object).length);
        this.assertEquals("GPGSA sentence should have been parsed", 4L, n);
        GPSRecord gPSRecord = nMEAParser.getRecordBuffer();
        this.assertEquals("GPGSA horizontal accuracy", "2.1", gPSRecord.hdop);
        this.assertEquals("GPGSA vertical accuracy", "3.6", gPSRecord.vdop);
    }

    public void testBatchData() {
        Object object = "$GPGSV,3,1,11,23,67,353,35,20,58,177,26,16,44,074,34,13,41,308,29*76\r\n$GPGSV,3,2,11,25,36,049,,27,25,246,32,04,16,292,,01,14,093,*70\r\n$GPGSV,3,3,11,31,05,054,,03,02,128,,08,00,236,*4A\r\n$GPRMC,063559.998,A,3746.0171,N,12226.1277,W,0.50,149.79,140207,,*15\r\n$PSRFTXT,Version:GSW3.1.1TO_3.1.00.07-C23P1.00\r\n$PSRFTXT,Version2:F-GPS-03-0510032\r\n$PSRFTXT,WAAS Enable\r\n$PSRFTXT,TOW:  282973\r\n$PSRFTXT,WK:   1414\r\n$PSRFTXT,POS:  -2707674 -4260780 3885049\r\n$PSRFTXT,CLK:  94976\r\n$PSRFTXT,CHNL: 12\r\n$PSRFTXT,Baud rate: 38400  System clock: 1058.797MHz\r\n$GPGGA,063601.002,3746.0171,N,12226.1278,W,1,05,2.1,59.7,M,-25.3,M,,0000*52\r\n$GPGSA,A,3,23,16,13,27,,,,,,,,,6.0,2.8,5.3*39\r\n$GPRMC,063601.002,A,3746.0171,N,12226.1278,W,0.47,305.20,140207,,*1E\r\n$PSRFTXT,Version:GSW3.1.1TO_3.1.00.07-C23P1.00\r\n$GPRMC,063601.002,A,3745.1313,N,12226.6666,W,0.47,305.20,140207,,*EE\r\n";
        object = "$GPGSV,3,1,11,23,67,353,35,20,58,177,26,16,44,074,34,13,41,308,29*76\r\n$GPGSV,3,2,11,25,36,049,,27,25,246,32,04,16,292,,01,14,093,*70\r\n$GPGSV,3,3,11,31,05,054,,03,02,128,,08,00,236,*4A\r\n$GPRMC,063559.998,A,3746.0171,N,12226.1277,W,0.50,149.79,140207,,*15\r\n$PSRFTXT,Version:GSW3.1.1TO_3.1.00.07-C23P1.00\r\n$PSRFTXT,Version2:F-GPS-03-0510032\r\n$PSRFTXT,WAAS Enable\r\n$PSRFTXT,TOW:  282973\r\n$PSRFTXT,WK:   1414\r\n$PSRFTXT,POS:  -2707674 -4260780 3885049\r\n$PSRFTXT,CLK:  94976\r\n$PSRFTXT,CHNL: 12\r\n$PSRFTXT,Baud rate: 38400  System clock: 1058.797MHz\r\n$GPGGA,063601.002,3746.0171,N,12226.1278,W,1,05,2.1,59.7,M,-25.3,M,,0000*52\r\n$GPGSA,A,3,23,16,13,27,,,,,,,,,6.0,2.8,5.3*39\r\n$GPRMC,063601.002,A,3746.0171,N,12226.1278,W,0.47,305.20,140207,,*1E\r\n$PSRFTXT,Version:GSW3.1.1TO_3.1.00.07-C23P1.00\r\n$GPRMC,063601.002,A,3745.1313,N,12226.6666,W,0.47,305.20,140207,,*EE\r\n".getBytes();
        NMEAParser nMEAParser = new NMEAParser();
        int n = 0;
        for (int i = 0; i < ((Object)object).length; i += 35) {
            int n2 = i + 35;
            if (n2 >= ((Object)object).length) {
                n2 = ((Object)object).length - 1;
            }
            byte[] byArray = new byte[n2 -= i];
            System.arraycopy(object, i, byArray, 0, n2);
            n |= nMEAParser.parse(byArray, n2);
        }
        this.assertEquals("All sentences should have been parsed", 7L, n);
        GPSRecord gPSRecord = nMEAParser.getRecordBuffer();
        this.assertEquals("GPRMC latitude", "3746.0171", gPSRecord.lattitude);
        this.assertEquals("GPRMC latitude direction", 78L, gPSRecord.lattitudeDirection);
        this.assertEquals("GPRMC longitude", "12226.1278", gPSRecord.longitude);
        this.assertEquals("GPRMC longitude direction", 87L, gPSRecord.longitudeDirection);
        this.assertEquals("GPRMC speed", "0.47", gPSRecord.speed);
        this.assertEquals("GPRMC course", "305.20", gPSRecord.course);
        this.assertEquals("GPGGA altitude", "59.7", gPSRecord.altitude);
        this.assertEquals("GPGSA horizontal accuracy", "2.8", gPSRecord.hdop);
        this.assertEquals("GPGSA vertical accuracy", "5.3", gPSRecord.vdop);
    }
}

