/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.BluetoothLocationProvider;
import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.JSR179LocationProvider;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.logging.Log;

public abstract class LocationProvider {
    public static final int AVAILABLE = 1;
    public static final int TEMPORARILY_UNAVAILABLE = 2;
    public static final int OUT_OF_SERVICE = 3;
    private static LocationProvider a;

    protected LocationProvider() {
    }

    public static String[][] discoverBluetoothDevices() {
        String[][] stringArray = null;
        if (!LocationProvider.supportsBluetoothAPI()) {
            return null;
        }
        stringArray = null;
        try {
            stringArray = (String[][])Class.forName("org.j4me.bluetoothgps.BluetoothDeviceDiscovery").newInstance();
        }
        catch (Exception exception) {
            Log.warn("Cannot discover Bluetooth devices", exception);
            return null;
        }
        stringArray = stringArray.discoverNearbyDeviceNamesAndAddresses();
        return stringArray;
    }

    public static LocationProvider getInstance(Criteria criteria) {
        LocationProvider locationProvider = null;
        LocationException locationException = null;
        if (criteria.isLocalLBSAllowed() && LocationProvider.supportsLocationAPI()) {
            try {
                locationProvider = JSR179LocationProvider.getInstance(criteria);
            }
            catch (LocationException locationException2) {
                LocationException locationException3 = locationException2;
                locationException = locationException2;
            }
        }
        if (locationProvider == null) {
            try {
                locationProvider = BluetoothLocationProvider.getInstance(criteria);
            }
            catch (LocationException locationException4) {
                if (locationException != null) {
                    throw locationException;
                }
                throw locationException4;
            }
        }
        a = locationProvider;
        return locationProvider;
    }

    public static boolean supportsLocationAPI() {
        try {
            Class.forName("javax.microedition.location.LocationProvider");
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static boolean supportsBluetoothAPI() {
        try {
            Class.forName("javax.bluetooth.LocalDevice");
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public abstract int getState();

    public abstract Location getLocation(int var1);

    public abstract void setLocationListener(LocationListener var1, int var2, int var3, int var4);

    public abstract void close();

    public abstract void reset();

    public static Location getLastKnownLocation() {
        if (a == null) {
            return null;
        }
        return a.getLastKnownLocationToProvider();
    }

    protected abstract Location getLastKnownLocationToProvider();
}

