/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.util.MathFunc;

public class Coordinates {
    public static final int DD_MM_SS = 1;
    public static final int DD_MM = 2;
    private float a;
    private double b;
    private double c;

    public Coordinates(double d, double d2, float f) {
        this.setLatitude(d);
        this.setLongitude(d2);
        this.setAltitude(f);
    }

    public double getLatitude() {
        return this.b;
    }

    public double getLongitude() {
        return this.c;
    }

    public float getAltitude() {
        return this.a;
    }

    public void setAltitude(float f) {
        this.a = f;
    }

    public void setLatitude(double d) {
        if (Double.isNaN(d) || d < -90.0 || d >= 90.0) {
            throw new IllegalArgumentException("Latitude (" + d + ") is invalid.");
        }
        this.b = d;
    }

    public void setLongitude(double d) {
        if (Double.isNaN(d) || d < -180.0 || d >= 180.0) {
            throw new IllegalArgumentException("Longitude (" + d + ") is invalid.");
        }
        this.c = d;
    }

    public float azimuthTo(Coordinates coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("azimuthTo does not accept a null parameter.");
        }
        double d = Math.toRadians(this.b);
        double d2 = Math.toRadians(this.c);
        double d3 = Math.toRadians(coordinates.b);
        double d4 = Math.toRadians(coordinates.c);
        double d5 = d4 - d2;
        double d6 = Math.cos(d3);
        double d7 = Math.sin(d5) * d6;
        double d8 = Math.cos(d) * Math.sin(d3) - Math.sin(d) * d6 * Math.cos(d5);
        double d9 = MathFunc.atan2(d7, d8);
        double d10 = Math.toDegrees(d9);
        d10 = (d10 + 360.0) % 360.0;
        return (float)d10;
    }

    public float distance(Coordinates coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException("distance does not accept a null parameter.");
        }
        double d = Math.toRadians(this.b);
        double d2 = Math.toRadians(this.c);
        double d3 = Math.toRadians(coordinates.b);
        double d4 = Math.toRadians(coordinates.c);
        double d5 = Math.sin((d - d3) / 2.0);
        double d6 = d5 * d5;
        double d7 = Math.cos(d) * Math.cos(d3);
        double d8 = Math.sin((d2 - d4) / 2.0);
        double d9 = d8 * d8;
        double d10 = d6 + d7 * d9;
        double d11 = 2.0 * MathFunc.asin(Math.sqrt(d10));
        double d12 = d11 * 6371000.0;
        return (float)d12;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Coordinates)) {
            return false;
        }
        object = (Coordinates)object;
        if (this.b < ((Coordinates)object).b - 1.0E-6 || this.b > ((Coordinates)object).b + 1.0E-6) {
            return false;
        }
        if (this.c < ((Coordinates)object).c - 1.0E-6 || this.c > ((Coordinates)object).c + 1.0E-6) {
            return false;
        }
        if (Float.isNaN(this.a) && !Float.isNaN(((Coordinates)object).a)) {
            return false;
        }
        if (!Float.isNaN(this.a) && Float.isNaN(((Coordinates)object).a)) {
            return false;
        }
        if (Float.isNaN(this.a) && Float.isNaN(((Coordinates)object).a)) {
            return true;
        }
        return !((double)this.a < (double)((Coordinates)object).a - 1.0E-6) && !((double)this.a > (double)((Coordinates)object).a + 1.0E-6);
    }

    public String toString() {
        String string;
        if (this.b >= 0.0) {
            string = String.valueOf(this.b);
            string = string + "\u00b0N ";
        } else {
            string = String.valueOf(-1.0 * this.b);
            string = string + "\u00b0S ";
        }
        if (this.c >= 0.0) {
            string = string + String.valueOf(this.c);
            string = string + "\u00b0E";
        } else {
            string = string + String.valueOf(-1.0 * this.c);
            string = string + "\u00b0W";
        }
        if (!Float.isNaN(this.a)) {
            string = string + " " + this.a + "m";
        }
        return string;
    }
}

