/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import org.j4me.bluetoothgps.BluetoothGPS;
import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.logging.Log;

class BluetoothLocationProvider
extends LocationProvider {
    private static BluetoothLocationProvider a = null;
    private BluetoothGPS b = null;
    private String c = null;
    private int d = 2;

    public static LocationProvider getInstance(Criteria object) {
        if (a != null) {
            throw new LocationException("Bluetooth GPS socket already in use.");
        }
        if (BluetoothLocationProvider.matchesCriteria((Criteria)object)) {
            object = ((Criteria)object).getRemoteDeviceAddress();
            return BluetoothLocationProvider.getInstance((String)object);
        }
        return null;
    }

    private BluetoothLocationProvider(String string, String string2) {
        for (int i = 1; i <= 2; ++i) {
            try {
                String string3 = this.c = BluetoothLocationProvider.constructBTURL(string, Integer.toString(i));
                Object object = this;
                object = new BluetoothGPS((BluetoothLocationProvider)object, string3);
                ((BluetoothGPS)object).start();
                this.b = object;
                return;
            }
            catch (IOException iOException) {
                if (Log.isDebugEnabled()) {
                    Log.debug("Channel ID = " + i + " failed:  " + iOException.toString());
                }
                if (i != 2) continue;
                throw iOException;
            }
        }
    }

    public static boolean matchesCriteria(Criteria criteria) {
        if (criteria.getHorizontalAccuracy() < 1) {
            return false;
        }
        if (criteria.isAltitudeRequired() && criteria.getVerticalAccuracy() < 1) {
            return false;
        }
        if (criteria.getPreferredResponseTime() > 500 && criteria.getPreferredResponseTime() < 500) {
            return false;
        }
        if (criteria.getPreferredPowerConsumption() == 1) {
            return false;
        }
        if (criteria.isAddressInfoRequired()) {
            return false;
        }
        return criteria.getRemoteDeviceAddress() != null;
    }

    public static BluetoothLocationProvider getInstance(String string) {
        if (a == null) {
            a = new BluetoothLocationProvider(string, null);
        }
        return a;
    }

    protected static String constructBTURL(String string, String string2) {
        if (string2 == null || string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.substring(0, "btspp://".length()).equalsIgnoreCase("btspp://")) {
            stringBuffer.append("btspp://");
        }
        stringBuffer.append(string);
        if (string.indexOf(58, "btspp://".length() + 1) < 0) {
            stringBuffer.append(':');
            stringBuffer.append(string2);
        }
        if (string.indexOf(59) < 0) {
            stringBuffer.append(";master=false;encrypt=false;authenticate=false");
        }
        string = stringBuffer.toString();
        return string;
    }

    public int getState() {
        return this.d;
    }

    public void setState(int n) {
        this.d = n;
    }

    public Location getLocation(int n) {
        Location location;
        if (n == 0 || n < -1) {
            throw new IllegalArgumentException();
        }
        long l = System.currentTimeMillis();
        n *= 1000;
        do {
            if (this.d == 3 || this.b == null) {
                throw new LocationException("Bluetooth location provider is out of service");
            }
            location = this.b.getLastKnownLocation();
            if (location != null) continue;
            Thread.sleep(250L);
            if (System.currentTimeMillis() - l <= (long)n) continue;
            throw new LocationException("Timed out getting location from Bluetooth location provider");
        } while (location == null);
        return location;
    }

    protected Location getLastKnownLocationToProvider() {
        return this.b.getLastKnownLocation();
    }

    public void setLocationListener(LocationListener locationListener, int n, int n2, int n3) {
        this.b.setLocationListener(locationListener, n, n2, n3);
    }

    public String getBluetoothURL() {
        return this.c;
    }

    public void reset() {
        if (this.b != null) {
            this.b.reacquireFix();
            this.b.setProviderState(2);
        }
    }

    public void close() {
        if (this.b != null) {
            this.b.stop();
            this.d = 3;
            this.b.setLocationListener(null, -1, -1, -1);
        }
    }
}

