/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.StreamConnection;
import org.j4me.bluetoothgps.BluetoothLocationProvider;
import org.j4me.bluetoothgps.BluetoothReadTimeoutThread;
import org.j4me.bluetoothgps.Coordinates;
import org.j4me.bluetoothgps.GPSRecord;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationImpl;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.NMEAParser;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.logging.Log;
import org.j4me.util.ConnectorHelper;

class BluetoothGPS
implements Runnable {
    public static final short SLEEP_BEFORE_READ = 100;
    public static final short READ_TIMEOUT = 3100;
    public static final short BLUETOOTH_CONNECTION_INIT_SLEEP = 200;
    private static final int[] a = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private StreamConnection b;
    private InputStream c;
    private OutputStream d;
    private Thread e;
    private boolean f = false;
    private String g;
    private LocationListener h;
    private final BluetoothLocationProvider i;
    private long j;
    private long k;
    private Location l;

    public BluetoothGPS(BluetoothLocationProvider bluetoothLocationProvider, String string) {
        this.i = bluetoothLocationProvider;
        this.g = string;
    }

    public Location getLastKnownLocation() {
        return this.l;
    }

    private synchronized void a() {
        if (!this.isConnected()) {
            Log.info("Connecting to Bluetooth device at " + this.g);
            this.b = (StreamConnection)ConnectorHelper.open(this.g, 3, 3000);
            Log.debug("Bluetooth connection established");
            BluetoothGPS bluetoothGPS = this;
            if (bluetoothGPS.d != null) {
                try {
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,00,00,01,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,02,00,01,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,04,00,01,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,01,00,00,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,03,00,00,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,05,00,00,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,06,00,00,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,07,00,00,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,08,00,00,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,09,00,00,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PSRF103,10,00,00,01"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PGRMO,,2"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PGRMO,GPGGA,1"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PGRMO,GPGSA,1"));
                    bluetoothGPS.d.write(BluetoothGPS.createSentence("PGRMO,GPRMC,1"));
                    bluetoothGPS.d.flush();
                    Log.debug("Configured GPS device settings");
                }
                catch (IOException iOException) {
                    Log.warn("Could not send configuration sentences to Bluetooth GPS", iOException);
                }
            }
            this.c = this.b.openInputStream();
            this.d = this.b.openOutputStream();
        }
    }

    public static byte[] createSentence(String object) {
        Object object2 = ((String)object).getBytes();
        int n = 0;
        for (int i = 0; i < ((byte[])object2).length; ++i) {
            n ^= object2[i];
        }
        String string = Integer.toHexString(n);
        string = string.toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        object2 = stringBuffer;
        stringBuffer.append('$');
        ((StringBuffer)object2).append((String)object);
        ((StringBuffer)object2).append('*');
        ((StringBuffer)object2).append(string);
        ((StringBuffer)object2).append("\r\n");
        object = ((StringBuffer)object2).toString();
        byte[] byArray = ((String)object).getBytes();
        object = byArray;
        return byArray;
    }

    private synchronized void b() {
        Log.debug("Disconnecting from GPS device");
        try {
            if (this.c != null) {
                this.c.close();
            }
            if (this.d != null) {
                this.d.close();
            }
            if (this.b != null) {
                this.b.close();
            }
        }
        catch (IOException iOException) {
            Log.warn("Problem closing GPS connection", iOException);
        }
        this.c = null;
        this.d = null;
        this.b = null;
    }

    public synchronized boolean isConnected() {
        return this.b != null && this.c != null;
    }

    public void reacquireFix() {
        if (this.d != null) {
            try {
                Object object = "PSRF104,0,0,0,0,0,0,12,2";
                if (this.l != null && this.l.isValid()) {
                    object = this.l.getQualifiedCoordinates();
                    long l = this.l.getTimestamp() - 936921587000L;
                    long l2 = l / 604800000L;
                    long l3 = l % 604800000L / 1000L;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("PSRF104,");
                    stringBuffer.append(((Coordinates)object).getLatitude());
                    stringBuffer.append(",");
                    stringBuffer.append(((Coordinates)object).getLongitude());
                    stringBuffer.append(",");
                    stringBuffer.append(Float.isNaN(((Coordinates)object).getAltitude()) ? 0.0f : ((Coordinates)object).getAltitude());
                    stringBuffer.append(",0,");
                    stringBuffer.append(l3);
                    stringBuffer.append(",");
                    stringBuffer.append(l2);
                    stringBuffer.append(",12,3");
                    object = stringBuffer.toString();
                }
                this.d.write(BluetoothGPS.createSentence((String)object));
                return;
            }
            catch (IOException iOException) {
                Log.warn("Could not re-acquire Bluetooth GPS fix", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        boolean bl = true;
        boolean bl2 = false;
        Object object = null;
        int n = 0;
        boolean bl3 = false;
        NMEAParser nMEAParser = new NMEAParser();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BluetoothReadTimeoutThread bluetoothReadTimeoutThread = new BluetoothReadTimeoutThread(this.e, 3100);
        boolean bl4 = true;
        while (bl) {
            try {
                if (this.f) {
                    this.stop();
                    return;
                }
                if (!this.isConnected()) {
                    this.a();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                object = new byte[2048];
                if (bl4) {
                    bluetoothReadTimeoutThread.start();
                    bl4 = false;
                } else {
                    bluetoothReadTimeoutThread.restart();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int n2 = this.c.read((byte[])object, 0, 2048);
                if (n2 < 0) {
                    throw new IOException("Bluetooth device closed connection");
                }
                bluetoothReadTimeoutThread.setReadSuccess(true);
                if (bl2 && n2 >= 2048 && n < 4) {
                    nMEAParser.flush();
                    n = (short)(n + 1);
                    continue;
                }
                bl2 = false;
                n = 0;
                try {
                    n2 = nMEAParser.parse((byte[])object, n2);
                    if ((n2 & 1) != 0) {
                        bl2 = true;
                        GPSRecord gPSRecord = nMEAParser.getRecordBuffer();
                        object = this;
                        if (gPSRecord != null && gPSRecord.quality != null) {
                            if (gPSRecord.quality.equals("1") || gPSRecord.quality.equals("2") || gPSRecord.quality.equals("3")) {
                                try {
                                    long l;
                                    float f = gPSRecord.altitude == null ? Float.NaN : Float.parseFloat(gPSRecord.altitude);
                                    float f2 = Float.parseFloat(gPSRecord.hdop);
                                    float f3 = Float.parseFloat(gPSRecord.vdop);
                                    float f4 = Float.parseFloat(gPSRecord.speed);
                                    f4 *= 0.5144445f;
                                    float f5 = gPSRecord.course == null ? Float.NaN : Float.parseFloat(gPSRecord.course);
                                    float f6 = BluetoothGPS.convertToDegress(gPSRecord.lattitude, gPSRecord.lattitudeDirection);
                                    float f7 = BluetoothGPS.convertToDegress(gPSRecord.longitude, gPSRecord.longitudeDirection);
                                    QualifiedCoordinates qualifiedCoordinates = new QualifiedCoordinates(f6, f7, f, f2, f3);
                                    long l2 = BluetoothGPS.convertUTCTime(gPSRecord.date, gPSRecord.secondsSinceMidnight);
                                    ((BluetoothGPS)object).l = new LocationImpl(qualifiedCoordinates, f4, f5, l2);
                                    ((BluetoothGPS)object).setProviderState(1);
                                    if (((BluetoothGPS)object).h != null && (l = System.currentTimeMillis()) - ((BluetoothGPS)object).k >= ((BluetoothGPS)object).j) {
                                        ((BluetoothGPS)object).k = l;
                                        try {
                                            ((BluetoothGPS)object).h.locationUpdated(((BluetoothGPS)object).i, ((BluetoothGPS)object).l);
                                        }
                                        catch (Throwable throwable) {
                                            Log.warn("Unhandled exception in LocationProvider.locationUpdated\n" + ((BluetoothGPS)object).l, throwable);
                                        }
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                }
                                catch (NullPointerException nullPointerException) {}
                            } else {
                                ((BluetoothGPS)object).setProviderState(2);
                            }
                        }
                        BluetoothGPS bluetoothGPS = this;
                        object = bluetoothGPS;
                        // MONITORENTER : bluetoothGPS
                        try {
                            this.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    if (n2 != -1) continue;
                    BluetoothGPS bluetoothGPS = this;
                    object = bluetoothGPS;
                    // MONITORENTER : bluetoothGPS
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable throwable) {
                    Log.warn("Problem parsing GPS data", throwable);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof InterruptedIOException) {
                    Log.info("Bluetooth GPS stalled.  Disconnecting and reconnecting.");
                } else if (throwable2 instanceof IOException) {
                    Log.info("Bluetooth device dropped connection.  Reconnecting.");
                } else if (throwable2 instanceof InterruptedException) {
                    bl = false;
                } else {
                    Log.warn("Unexpected GPS read error", throwable2);
                }
                this.setProviderState(2);
                this.b();
                BluetoothGPS bluetoothGPS = this;
                object = bluetoothGPS;
                // MONITORENTER : bluetoothGPS
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
                nMEAParser.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProviderState(int n) {
        if (this.i.getState() != n) {
            this.i.setState(n);
            if (this.h != null) {
                try {
                    this.h.providerStateChanged(this.i, n);
                }
                catch (Throwable throwable) {
                    Log.warn("Unhandled exception in LocationProvider.providerStateChanged to " + n, throwable);
                }
            }
            BluetoothGPS bluetoothGPS = this;
            synchronized (bluetoothGPS) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {}
                return;
            }
        }
    }

    public static float convertToDegress(String string, char c) {
        int n;
        if (string != null && (n = string.indexOf(46)) > 0) {
            float f = Float.parseFloat(string.substring(0, n -= 2));
            float f2 = Float.parseFloat(string.substring(n));
            f2 /= 60.0f;
            f2 = f + f2;
            if (c == 'S' || c == 's') {
                return -f2;
            }
            if (c == 'W' || c == 'w') {
                return -f2;
            }
            return f2;
        }
        return 0.0f;
    }

    public static long convertUTCTime(String string, String string2) {
        if (string == null || string2 == null) {
            return System.currentTimeMillis();
        }
        double d = Double.parseDouble(string2);
        int n = (int)(d *= 1000.0);
        int n2 = Integer.parseInt(string.substring(0, 2));
        int n3 = Integer.parseInt(string.substring(2, 4));
        int n4 = Integer.parseInt(string.substring(4, 6));
        long l = 10957L;
        l = 10957L + (long)(n4 * 365);
        l += (long)((n4 - 1) / 4 + 1);
        l += (long)a[n3 - 1];
        if (n4 % 4 == 0 && n3 >= 3) {
            ++l;
        }
        long l2 = (l += (long)n2) * 86400000L;
        return l2 += (long)n;
    }

    public synchronized void start() {
        this.a();
        if (this.e == null) {
            this.f = false;
            this.e = new Thread(this);
            this.e.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.e != null) {
            if (Thread.currentThread() == this.e) {
                this.e = null;
                this.b();
                this.setProviderState(2);
            } else {
                this.f = true;
                this.e.interrupt();
            }
        } else {
            this.b();
        }
        synchronized (this) {
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
    }

    public void setLocationListener(LocationListener locationListener, int n, int n2, int n3) {
        this.h = locationListener;
        if (n < 1) {
            this.j = 1000L;
            return;
        }
        this.j = n * 1000;
    }
}

