/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import org.j4me.logging.Log;

class BluetoothDeviceDiscovery
implements DiscoveryListener {
    public static final int INQUIRY_IN_PROGRESS = -1;
    public static final int SERVICE_SEARCH_IN_PROGRESS = -1;
    private DiscoveryAgent a;
    private Vector b = new Vector();
    private Vector c = new Vector();
    private int d = -1;
    private int e = -1;

    BluetoothDeviceDiscovery() {
    }

    public String[][] discoverNearbyDeviceNamesAndAddresses() {
        stringArray.doDiscoverDevices();
        while (stringArray.getDeviceDiscoveryResult() == -1) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (stringArray.getDeviceDiscoveryResult() != 0) {
            throw new IOException("Search for Bluetooth devices failed (code " + stringArray.getDeviceDiscoveryResult() + ").");
        }
        String[][] stringArray = stringArray.getDiscoveredDevices();
        Enumeration enumeration = stringArray.elements();
        stringArray = new String[stringArray.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String[] stringArray2 = (RemoteDevice)enumeration.nextElement();
            String string = stringArray2.getFriendlyName(false);
            stringArray2 = stringArray2.getBluetoothAddress();
            if (string == null) {
                string = stringArray2;
            }
            stringArray2 = new String[]{string, stringArray2};
            stringArray[n] = stringArray2;
            ++n;
        }
        return stringArray;
    }

    public void doDiscoverDevices() {
        Log.debug("Starting Bluetooth device discovery");
        LocalDevice localDevice = LocalDevice.getLocalDevice();
        this.a = localDevice.getDiscoveryAgent();
        this.a.startInquiry(10390323, (DiscoveryListener)this);
    }

    public void doDiscoverService(RemoteDevice remoteDevice) {
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        this.a.searchServices(nArray, new UUID[]{new UUID(256L)}, remoteDevice, (DiscoveryListener)this);
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        Log.debug("Discovered device " + remoteDevice.getBluetoothAddress());
        this.b.addElement(remoteDevice);
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        if (Log.isInfoEnabled()) {
            Log.info("Found services " + serviceRecordArray.length);
        }
        for (n = 0; n < serviceRecordArray.length; ++n) {
            ServiceRecord serviceRecord = serviceRecordArray[n];
            this.c.addElement(serviceRecord);
        }
    }

    public void serviceSearchCompleted(int n, int n2) {
        this.e = n2;
    }

    public void inquiryCompleted(int n) {
        this.d = n;
    }

    public Vector getDiscoveredDevices() {
        return this.b;
    }

    public RemoteDevice getDeviceByFriendlyName(String string) {
        Enumeration enumeration = ((BluetoothDeviceDiscovery)((Object)enumeration)).b.elements();
        RemoteDevice remoteDevice = null;
        while (enumeration.hasMoreElements() && !(remoteDevice = (RemoteDevice)enumeration.nextElement()).getFriendlyName(false).equals(string)) {
        }
        return remoteDevice;
    }

    public ServiceRecord getFirstDiscoveredService() {
        if (this.c.size() > 0) {
            return (ServiceRecord)this.c.elementAt(0);
        }
        return null;
    }

    public int getDeviceDiscoveryResult() {
        return this.d;
    }

    public String getDeviceDiscoveryResultAsString() {
        switch (this.d) {
            case 0: {
                return "Completed";
            }
            case 7: {
                return "Error";
            }
            case 5: {
                return "Terminated";
            }
        }
        return "Unknown Code";
    }

    public int getServiceSearchResult() {
        return this.e;
    }

    public String getServiceSearchResultAsString() {
        switch (this.e) {
            case 1: {
                return "Completed";
            }
            case 2: {
                return "Terminated";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "No Records";
            }
            case 6: {
                return "Device Not Reachable";
            }
        }
        return "Unknown Code";
    }

    public static String findChannelId(ServiceRecord object) {
        object = object.getAttributeValue(4);
        object = (Enumeration)object.getValue();
        while (object.hasMoreElements()) {
            Object object2 = (DataElement)object.nextElement();
            DataElement dataElement = (DataElement)(object2 = (Enumeration)object2.getValue()).nextElement();
            if (!dataElement.getValue().equals(new UUID(3L))) continue;
            object = (DataElement)object2.nextElement();
            int n = (int)object.getLong();
            return Integer.toString(n);
        }
        return null;
    }
}

