/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.textui;

import j2meunit.framework.AssertionFailedError;
import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestFailure;
import j2meunit.framework.TestListener;
import j2meunit.framework.TestResult;
import j2meunit.util.StringUtil;
import j2meunit.util.Version;
import java.io.PrintStream;

public class TestRunner
implements TestListener {
    protected PrintStream fWriter = System.out;

    public TestRunner() {
    }

    public TestRunner(PrintStream printStream) {
        this.fWriter = printStream;
    }

    public synchronized void addError(Test test, Throwable throwable) {
        this.fWriter.print("E");
    }

    public synchronized void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.fWriter.print("F");
    }

    public void endTest(Test test) {
    }

    public void endTestStep(Test test) {
        this.fWriter.print(".");
    }

    public static void main(String[] stringArray) {
        System.out.println("TestRunner.main()");
        TestRunner testRunner = new TestRunner();
        testRunner.start(stringArray);
    }

    public synchronized void print(TestResult testResult) {
        this.printHeader(testResult);
        this.printErrors(testResult);
        this.printFailures(testResult);
    }

    public void printErrors(TestResult object) {
        if (((TestResult)object).errorCount() != 0) {
            if (((TestResult)object).errorCount() == 1) {
                this.fWriter.println("There was " + ((TestResult)object).errorCount() + " error:");
            } else {
                this.fWriter.println("There were " + ((TestResult)object).errorCount() + " errors:");
            }
            int n = 1;
            object = ((TestResult)object).errors();
            while (object.hasMoreElements()) {
                TestFailure testFailure = (TestFailure)object.nextElement();
                this.fWriter.println(n + ") " + testFailure.failedTest());
                this.fWriter.println(testFailure.thrownException().getMessage());
                ++n;
            }
        }
    }

    public void printFailures(TestResult object) {
        if (((TestResult)object).failureCount() != 0) {
            if (((TestResult)object).failureCount() == 1) {
                this.fWriter.println("There was " + ((TestResult)object).failureCount() + " failure:");
            } else {
                this.fWriter.println("There were " + ((TestResult)object).failureCount() + " failures:");
            }
            int n = 1;
            object = ((TestResult)object).failures();
            while (object.hasMoreElements()) {
                TestFailure testFailure = (TestFailure)object.nextElement();
                this.fWriter.print(n + ") " + testFailure.failedTest());
                Throwable throwable = testFailure.thrownException();
                if (throwable.getMessage() != null) {
                    this.fWriter.println(" \"" + StringUtil.truncate(throwable.getMessage(), 80) + "\"");
                } else {
                    this.fWriter.println();
                    this.fWriter.println(testFailure.thrownException().getMessage());
                }
                ++n;
            }
        }
    }

    public void printHeader(TestResult testResult) {
        if (testResult.wasSuccessful()) {
            this.fWriter.println();
            this.fWriter.print("OK");
            this.fWriter.println(" (" + testResult.runCount() + " tests)");
            return;
        }
        this.fWriter.println();
        this.fWriter.println("FAILURES!!!");
        this.fWriter.println("Test Results:");
        this.fWriter.println("Run: " + testResult.runCount() + " Failures: " + testResult.failureCount() + " Errors: " + testResult.errorCount());
    }

    public static void run(Test test) {
        TestRunner testRunner = new TestRunner();
        testRunner.doRun(test);
    }

    public synchronized void startTest(Test test) {
        System.out.print(".");
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected void doRun(Test test) {
        TestResult testResult = this.createTestResult();
        testResult.addListener(this);
        long l = System.currentTimeMillis();
        test.run(testResult);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.fWriter.println();
        this.fWriter.println("Time: " + StringUtil.elapsedTimeAsString(l3));
        this.print(testResult);
        this.fWriter.println();
        if (!testResult.wasSuccessful()) {
            System.exit(-1);
        }
        System.exit(0);
    }

    protected String processArguments(String[] stringArray) {
        Object object = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-v")) {
                System.out.println("J2ME Unit " + Version.id() + "by RoleModel Software, Inc. \nOriginal JUnit by Kent Beck and Erich Gamma");
                continue;
            }
            object = stringArray[i];
        }
        if (((String)object).equals("")) {
            System.out.println("Usage: TestRunner testCaseName, where name is the name of the TestCase class");
            System.exit(-1);
        }
        return object;
    }

    protected void start(String[] object) {
        object = this.processArguments((String[])object);
        try {
            object = Class.forName((String)object);
            object = (TestCase)object.newInstance();
            object = object.suite();
            this.doRun((Test)object);
            return;
        }
        catch (Exception exception) {
            System.out.println("Could not create and run test suite");
            System.exit(-1);
            return;
        }
    }
}

