/*
 * Decompiled with CFR 0.152.
 */
package dove6.gui;

import dove6.Base64;
import dove6.BasicDove6;
import dove6.gui.ImageCanvas;
import dove6.io.GestioneFile;
import dove6.io.InterfaceFileChooserListener;
import dove6.util.Dove6Utility;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class CanvasImageToSend
extends ImageCanvas
implements InterfaceFileChooserListener,
CommandListener {
    private Command a = new Command("Annulla", 7, 1);
    private Command b = new Command("Invia", 1, 1);
    private Command c = new Command("Indietro", 2, 1);
    private String d;
    private String e;

    public CanvasImageToSend(BasicDove6 basicDove6) {
        super(basicDove6, null);
        this.addCommand(this.a);
        this.addCommand(this.b);
        this.addCommand(this.c);
        this.removeCommand(imgCanvasExit);
        this.setCommandListener(this);
        new GestioneFile(basicDove6, (Displayable)this, this, false);
    }

    public void fileChoosed(FileConnection fileConnection) {
        try {
            super.setIm(null);
            InputStream inputStream = null;
            Image image = null;
            if (fileConnection != null) {
                inputStream = fileConnection.openInputStream();
            }
            if (fileConnection == null || !fileConnection.exists()) {
                throw new IOException("File does not exists");
            }
            long l = Dove6Utility.getFreeMemory();
            String string = fileConnection.getURL().substring(0, fileConnection.getURL().indexOf(fileConnection.getName(), 0));
            if (string != null) {
                this.d = string;
            }
            if (fileConnection.exists() && fileConnection.fileSize() > l) {
                this.message = "File too big, " + fileConnection.fileSize() / 1024L + " kb";
            } else if (!fileConnection.exists()) {
                fileConnection.create();
            } else {
                image = Image.createImage((InputStream)inputStream);
                this.e = fileConnection.getURL();
            }
            inputStream.close();
            fileConnection.close();
            super.setIm(image);
            this.midlet.setDisplayable((Displayable)this);
            return;
        }
        catch (Exception exception) {
            if (BasicDove6.isDebug()) {
                exception.printStackTrace();
                this.midlet.toLog("CanvasImageToSend.fileChoosed(" + fileConnection.getURL() + ")\nerrore: " + exception.getMessage());
            }
            this.midlet.showAlert("Attenzione", "Impossibile caricare l'immagine!", AlertType.ERROR);
            return;
        }
    }

    public String getFileImageB64() {
        try {
            int n;
            if (this.e == null) {
                this.midlet.showAlert("Invio Posizione", "Nessuna immagine da inviare, operazione annullata!", AlertType.ERROR);
                return this.e;
            }
            Object object = (FileConnection)Connector.open((String)this.e);
            Dove6Utility.getFreeMemory();
            if (!object.exists()) {
                throw new IOException("File does not exists");
            }
            InputStream inputStream = object.openInputStream();
            long l = object.fileSize();
            byte[] byArray = new byte[(int)l];
            int n2 = 0;
            for (n = 0; n < byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) >= 0; n += n2) {
            }
            if (n < byArray.length) {
                throw new IOException("Could not completely read file " + this.e);
            }
            inputStream.close();
            object.close();
            object = Base64.base64Encode(byArray);
            return object;
        }
        catch (Exception exception) {
            if (BasicDove6.isDebug()) {
                this.midlet.toLog("CanvasImageToSend.getFile()\nerrore: " + exception.getMessage());
            }
            return null;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.a) {
            super.setIm(null);
            this.midlet.showForm((Displayable)this);
            return;
        }
        if (command == this.b) {
            super.setIm(null);
            this.midlet.setImgTS(this.e, (Displayable)this);
            return;
        }
        if (command == this.c) {
            super.setIm(null);
            if (this.d == null) {
                new GestioneFile(this.midlet, (Displayable)this, this, false);
                return;
            }
            new GestioneFile(this.midlet, (Displayable)this, this, this.d, false);
        }
    }

    public void exit() {
        this.midlet.showForm((Displayable)this);
    }

    public void keyPressed(int n) {
    }
}

