/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.util;

public final class MathFunc {
    public static double acos(double d) {
        if (Double.isNaN(d) || Math.abs(d) > 1.0) {
            return Double.NaN;
        }
        double d2 = d * d;
        double d3 = MathFunc.atan2(Math.sqrt(1.0 - d2), d);
        return d3;
    }

    public static double asin(double d) {
        if (Double.isNaN(d) || Math.abs(d) > 1.0) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return d;
        }
        double d2 = d * d;
        double d3 = MathFunc.atan2(d, Math.sqrt(1.0 - d2));
        return d3;
    }

    public static double atan(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return d;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (d < 0.0) {
            d = -d;
            bl = true;
        }
        if (d > 1.0) {
            d = 1.0 / d;
            bl2 = true;
        }
        while (d > 0.2617993877991494) {
            ++n;
            double d2 = d + 1.732050807569;
            d2 = 1.0 / d2;
            d *= 1.732050807569;
            d -= 1.0;
            d *= d2;
        }
        double d3 = d * d;
        double d4 = d3 + 1.4087812;
        d4 = 0.55913709 / d4;
        d4 += 0.60310579;
        d4 -= d3 * 0.05160454;
        d4 *= d;
        while (n > 0) {
            d4 += 0.5235987755982988;
            --n;
        }
        if (bl2) {
            d4 = 1.5707963267948966 - d4;
        }
        if (bl) {
            d4 = -d4;
        }
        return d4;
    }

    public static double atan2(double d, double d2) {
        double d3;
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            if (d > 0.0) {
                if (Double.isInfinite(d2)) {
                    if (d2 > 0.0) {
                        return 0.7853981633974483;
                    }
                    return 2.356194490192345;
                }
                if (d2 != 0.0) {
                    return 1.5707963267948966;
                }
            } else {
                if (Double.isInfinite(d2)) {
                    if (d2 > 0.0) {
                        return -0.7853981633974483;
                    }
                    return -2.356194490192345;
                }
                if (d2 != 0.0) {
                    return -1.5707963267948966;
                }
            }
        } else if (d == 0.0) {
            if (d2 > 0.0) {
                return d;
            }
            if (d2 < 0.0) {
                return Math.PI;
            }
        } else if (Double.isInfinite(d2)) {
            if (d2 > 0.0) {
                if (d > 0.0) {
                    return 0.0;
                }
                if (d < 0.0) {
                    return -0.0;
                }
            } else {
                if (d > 0.0) {
                    return Math.PI;
                }
                if (d < 0.0) {
                    return -Math.PI;
                }
            }
        } else if (d2 == 0.0) {
            if (d > 0.0) {
                return 1.5707963267948966;
            }
            if (d < 0.0) {
                return -1.5707963267948966;
            }
        }
        if (Math.abs(d2) > Math.abs(d)) {
            d3 = MathFunc.atan(d / d2);
        } else {
            double d4;
            d3 = MathFunc.atan(d2 / d);
            d3 = d4 < 0.0 ? -1.5707963267948966 - d3 : 1.5707963267948966 - d3;
        }
        if (d2 < 0.0) {
            d3 = d < 0.0 ? (d3 -= Math.PI) : (d3 += Math.PI);
        }
        return d3;
    }

    public static int round(float f) {
        return (int)Math.floor(f + 0.5f);
    }

    public static long round(double d) {
        return (long)Math.floor(d + 0.5);
    }
}

