/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.j4me.util.MathFunc;

public class Theme {
    public static final int BLACK = 0;
    public static final int BROWN = 0x804000;
    public static final int BLUE = 255;
    public static final int NAVY = 128;
    public static final int NEON_BLUE = 0x4DFFFF;
    public static final int LIGHT_BLUE = 33023;
    public static final int RED = 0xFF0000;
    public static final int MAROON = 0x802020;
    public static final int LIGHT_RED = 0xFF5050;
    public static final int MAGENTA = 0xFF28FF;
    public static final int ORANGE = 0xFF8000;
    public static final int BURNT_ORANGE = 0xD07000;
    public static final int YELLOW = 0xFFFF00;
    public static final int GREEN = 0x66FF33;
    public static final int MEDIUM_GREEN = 42752;
    public static final int LIGHT_GREEN = 3194912;
    public static final int DARK_GREEN = 2048813;
    public static final int FOREST_GREEN = 0x33773A;
    public static final int BLUE_GREEN = 32896;
    public static final int CYAN = 0x33FFFF;
    public static final int SILVER = 0xC0C0C0;
    public static final int GRAY = 0x808080;
    public static final int LIGHT_GRAY = 0xC0C0C0;
    public static final int LAVENDAR = 15132410;
    public static final int WHITE = 0xFFFFFF;
    private final Font a;
    private final Font b;
    private final Font c;

    public Theme() {
        Font font = Font.getDefaultFont();
        int n = font.getFace();
        int n2 = font.getSize();
        this.a = Font.getFont((int)n, (int)0, (int)n2);
        this.b = Font.getFont((int)n, (int)0, (int)n2);
        this.c = Font.getFont((int)n, (int)1, (int)n2);
    }

    public Font getFont() {
        return this.a;
    }

    public Font getMenuFont() {
        return this.b;
    }

    public Font getTitleFont() {
        return this.c;
    }

    public int getFontColor() {
        return 128;
    }

    public int getMenuFontColor() {
        return 0xFFFFFF;
    }

    public int getMenuFontHighlightColor() {
        return 0xC0C0C0;
    }

    public int getTitleFontColor() {
        return this.getMenuFontColor();
    }

    public int getBorderColor() {
        return 128;
    }

    public int getBackgroundColor() {
        return 0xFFFFFF;
    }

    public int getHighlightColor() {
        return 33023;
    }

    public int getTitleBarBorderColor() {
        return this.getMenuBarBorderColor();
    }

    public int getTitleBarBackgroundColor() {
        return this.getMenuBarBackgroundColor();
    }

    public int getTitleBarHighlightColor() {
        return this.getMenuBarHighlightColor();
    }

    public int getMenuBarBorderColor() {
        return this.getFontColor();
    }

    public int getMenuBarBackgroundColor() {
        return 128;
    }

    public int getMenuBarHighlightColor() {
        return 33023;
    }

    public int getTitleHeight() {
        return this.getTitleFont().getHeight() + 2;
    }

    public void paintTitleBar(Graphics graphics, String string, int n, int n2) {
        this.paintTitleBarBackground(graphics, 0, 0, n, n2);
        graphics.setColor(this.getTitleBarBorderColor());
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        graphics.setFont(this.getTitleFont());
        graphics.setColor(this.getTitleFontColor());
        graphics.drawString(string, n / 2, 1, 17);
    }

    protected void paintTitleBarBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        n = this.getTitleBarBackgroundColor();
        int n5 = this.getTitleBarHighlightColor();
        Theme.gradientFill(graphics, 0, 0, n3, n4, true, n, n5, 0.6);
    }

    public int getMenuHeight() {
        return this.getMenuFont().getHeight() + 2;
    }

    public void paintMenuBar(Graphics graphics, String string, boolean bl, String string2, boolean bl2, int n, int n2) {
        theme.paintMenuBarBackground(graphics, 0, 0, n, n2);
        graphics.setColor(theme.getMenuBarBorderColor());
        graphics.drawLine(0, 0, n, 0);
        int n3 = theme.getMenuFontColor();
        int n4 = theme.getMenuFontHighlightColor();
        Theme theme = theme.getMenuFont();
        graphics.setFont((Font)theme);
        int n5 = theme.charWidth(' ') / 2;
        graphics.setColor(bl ? n4 : n3);
        graphics.drawString(string, n5, n2, 36);
        graphics.setColor(bl2 ? n4 : n3);
        graphics.drawString(string2, n - n5, n2, 40);
    }

    protected void paintMenuBarBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.getMenuBarBackgroundColor();
        int n6 = this.getMenuBarHighlightColor();
        Theme.gradientFill(graphics, n, n2, n3, n4, true, n5, n6, 0.1);
    }

    public String getMenuTextForOK() {
        return "OK";
    }

    public String getMenuTextForCancel() {
        return "Cancel";
    }

    public void paintBackground(Graphics graphics) {
        int n = this.getBackgroundColor();
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        graphics.setColor(n);
        graphics.fillRect(n2, n3, n4, n5);
    }

    public void paintVerticalScrollbar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getVerticalScrollbarWidth();
        n = n + n3 - n7;
        this.paintScrollbarBackground(graphics, n, n2, n7, n4);
        n3 = this.getBorderColor();
        graphics.setColor(n3);
        graphics.drawLine(n, n2, n, n2 + n4);
        n3 = n6 - n4;
        double d = (double)n4 / (double)n6;
        n6 = (int)MathFunc.round((double)n4 * d);
        n6 = Math.max(n6, n7 * 2);
        int n8 = n6 / 2;
        double d2 = (double)n5 / (double)n3;
        n2 = n2 + n8 + (int)MathFunc.round(d2 * (double)(n4 -= n8 * 2));
        this.paintTrackbar(graphics, n, n2 - n8, n7, n6);
    }

    protected void paintScrollbarBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.getScrollbarBackgroundColor();
        int n6 = this.getScrollbarHighlightColor();
        Theme.gradientFill(graphics, n, n2, n3, n4, false, n5, n6, 0.8);
    }

    protected void paintTrackbar(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.getScrollbarTrackbarColor();
        int n6 = this.getScrollbarBorderColor();
        Theme.gradientFill(graphics, n, n2, n3, n4, false, n5, n6, 0.8);
    }

    public int getVerticalScrollbarWidth() {
        return 6;
    }

    public int getScrollbarBorderColor() {
        return this.getBorderColor();
    }

    public int getScrollbarBackgroundColor() {
        return this.getMenuBarBackgroundColor();
    }

    public int getScrollbarHighlightColor() {
        return this.getMenuFontHighlightColor();
    }

    public int getScrollbarTrackbarColor() {
        return this.getMenuBarHighlightColor();
    }

    public static void gradientFill(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, double d) {
        int n7 = n5 >> 16 & 0xFF;
        int n8 = n5 >> 8 & 0xFF;
        n5 &= 0xFF;
        int n9 = n6 >> 16 & 0xFF;
        int n10 = n6 >> 8 & 0xFF;
        n6 &= 0xFF;
        int n11 = bl ? n4 : n3;
        for (int i = 0; i < n11; ++i) {
            double d2 = (double)i / (double)n11;
            double d3 = Math.abs(d - d2);
            double d4 = 1.0 - d3;
            int n12 = (int)((double)n7 * d3 + (double)n9 * d4);
            int n13 = (int)((double)n8 * d3 + (double)n10 * d4);
            int n14 = (int)((double)n5 * d3 + (double)n6 * d4);
            graphics.setColor(n12, n13, n14);
            if (bl) {
                graphics.drawLine(n, n2 + i, n + n3, n2 + i);
                continue;
            }
            graphics.drawLine(n + i, n2, n + i, n2 + n4);
        }
    }
}

