/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.logging;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.logging.Level;
import org.j4me.logging.Log;
import org.j4me.logging.LogMessage;
import org.j4me.logging.LogTests$1;
import org.j4me.logging.LogTests$2;
import org.j4me.logging.LogTests$3;

public class LogTests
extends TestCase {
    public LogTests() {
    }

    public LogTests(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new LogTests("testGettingAndSettingLogLevels", new LogTests$1(this)));
        testSuite.addTest(new LogTests("testCircularBuffer", new LogTests$2(this)));
        testSuite.addTest(new LogTests("testLoggingAtAllLevels", new LogTests$3(this)));
        return testSuite;
    }

    public void testGettingAndSettingLogLevels() {
        Log.setLevel(Level.DEBUG);
        int n = Log.getLogLevel().toInt();
        Log.setLevel(Level.INFO);
        int n2 = Log.getLogLevel().toInt();
        Log.setLevel(Level.WARN);
        int n3 = Log.getLogLevel().toInt();
        Log.setLevel(Level.ERROR);
        int n4 = Log.getLogLevel().toInt();
        Log.setLevel(Level.OFF);
        int n5 = Log.getLogLevel().toInt();
        this.assertTrue("Debug less than Info", n < n2);
        this.assertTrue("Info less than Warn", n2 < n3);
        this.assertTrue("Warn less than Error", n3 < n4);
        this.assertTrue("Error less than Off", n4 < n5);
        Log.setLevel(n);
        this.assertTrue("Level set to debug", Log.getLogLevel() == Level.DEBUG);
        Log.setLevel(n2);
        this.assertTrue("Level set to info", Log.getLogLevel() == Level.INFO);
        Log.setLevel(n3);
        this.assertTrue("Level set to warn", Log.getLogLevel() == Level.WARN);
        Log.setLevel(n4);
        this.assertTrue("Level set to error", Log.getLogLevel() == Level.ERROR);
        Log.setLevel(n5);
        this.assertTrue("Level set to off", Log.getLogLevel() == Level.OFF);
        n2 = 0;
        try {
            Log.setLevel(n - 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n2 = 1;
        }
        this.assertTrue("IllegalArgumentException for invalid log int value", n2 != 0);
    }

    public void testCircularBuffer() {
        String string;
        int n;
        int n2;
        Log.setLevel(Level.DEBUG);
        Log.clear();
        Object object = Log.getLogMessages();
        this.assertEquals("There should be no log messages after clearing it.", 0L, ((LogMessage[])object).length);
        String string2 = "Simple test";
        Log.error("Simple test");
        object = Log.getLogMessages();
        this.assertEquals("There should be one log message.", 1L, ((LogMessage[])object).length);
        this.assertEquals("First log message level", Level.ERROR, object[0].level);
        this.assertEquals("First log message text", string2, object[0].message);
        object = object[0].toString();
        this.assertTrue("Message in toString()", ((String)object).indexOf(string2) >= 0);
        for (n2 = 0; n2 < 3; ++n2) {
            String string3 = String.valueOf(n2);
            Log.error(string3);
        }
        object = Log.getLogMessages();
        this.assertEquals("There should be 4 log messages.", 4L, ((Object)object).length);
        this.assertEquals("Simple log message is oldest and should be first.", string2, ((LogMessage)object[0]).message);
        for (n2 = 0; n2 < ((Object)object).length - 1; ++n2) {
            long l = ((LogMessage)object[n2 + 1]).time;
            long l2 = ((LogMessage)object[n2]).time;
            this.assertTrue("Timestamps should not be 0", l > 0L);
            this.assertTrue("Newer should have a bigger timestamp than older", l >= l2);
        }
        for (n = 1; n <= 30; ++n) {
            string = String.valueOf(n);
            Log.error(string);
        }
        object = Log.getLogMessages();
        this.assertTrue("Test did not make enough log messages to verify circular buffer", 30 > ((Object)object).length);
        for (n = 0; n < ((Object)object).length; ++n) {
            string = ((LogMessage)object[n]).message;
            int n3 = Integer.valueOf(string);
            this.assertEquals("Message in circular buffer", n + 6, n3);
        }
    }

    public void testLoggingAtAllLevels() {
        for (int i = 0; i < 5; ++i) {
            boolean bl;
            String string;
            LogTests logTests;
            boolean bl2;
            String string2;
            LogTests logTests2;
            if (i == 0) {
                Log.setLevel(Level.DEBUG);
            } else if (i == 1) {
                Log.setLevel(Level.INFO);
            } else if (i == 2) {
                Log.setLevel(Level.WARN);
            } else if (i == 3) {
                Log.setLevel(Level.ERROR);
            } else {
                Log.setLevel(Level.OFF);
            }
            if (i == 0) {
                logTests2 = this;
                string2 = "isDebugEnabled true";
                bl2 = Log.isDebugEnabled();
            } else {
                logTests2 = this;
                string2 = "isDebugEnabled false";
                bl2 = !Log.isDebugEnabled();
            }
            logTests2.assertTrue(string2, bl2);
            if (i <= 1) {
                logTests = this;
                string = "isInfoEnabled true";
                bl = Log.isInfoEnabled();
            } else {
                logTests = this;
                string = "isInfoEnabled false";
                bl = !Log.isInfoEnabled();
            }
            logTests.assertTrue(string, bl);
            Log.clear();
            Log.debug("debug");
            Log.info("info");
            Log.warn("warn");
            Log.warn("throwable", new Exception());
            Log.error("error");
            Log.error(null, new Error("error text"));
            LogMessage[] logMessageArray = Log.getLogMessages();
            if (i == 0) {
                this.assertEquals("Everything should be logged at debug", 6L, logMessageArray.length);
                this.assertEquals("Debug log level", Level.DEBUG, logMessageArray[0].level);
                this.assertEquals("Debug log message", "debug", logMessageArray[0].message);
            }
            if (i <= 1) {
                this.assertEquals("Info log level", Level.INFO, logMessageArray[1 - i].level);
                this.assertEquals("Info log message", "info", logMessageArray[1 - i].message);
            }
            if (i <= 2) {
                this.assertEquals("Warn log level", Level.WARN, logMessageArray[2 - i].level);
                this.assertEquals("Warn log message", "warn", logMessageArray[2 - i].message);
                this.assertEquals("Warn with exception log level", Level.WARN, logMessageArray[3 - i].level);
                this.assertTrue("Warn with exception log message text", logMessageArray[3 - i].message.indexOf("throwable") >= 0);
                this.assertTrue("Warn with exception log exception type", logMessageArray[3 - i].message.indexOf("Exception") >= 0);
            }
            if (i <= 3) {
                int n = i < 3 ? i : i + 1;
                this.assertEquals("Error log level", Level.ERROR, logMessageArray[4 - n].level);
                this.assertEquals("Error log message", "error", logMessageArray[4 - n].message);
                this.assertEquals("Error with exception log level", Level.ERROR, logMessageArray[5 - n].level);
                this.assertTrue("Error with exception log exception type", logMessageArray[5 - n].message.indexOf("Error") >= 0);
                this.assertTrue("Error with exception log exception message", logMessageArray[5 - n].message.indexOf("error text") >= 0);
            }
            if (i != 4) continue;
            this.assertEquals("Nothing should be logged at off", 0L, logMessageArray.length);
        }
    }
}

