/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import java.io.IOException;
import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.examples.bluetoothgps.AcquiringLocationAlert;
import org.j4me.examples.bluetoothgps.FindingGPSDevicesAlert;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.ui.screens.ErrorAlert;
import org.j4me.examples.ui.screens.ProgressAlert;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;

public class InitializingGPSAlert
extends ProgressAlert {
    private final LocationModel a;
    private final DeviceScreen b;

    public InitializingGPSAlert(LocationModel locationModel, DeviceScreen deviceScreen) {
        super("Initializing GPS...", "Connecting to the location provider.");
        Object object = locationModel.isGPSOnDevice();
        if (object != null && !((Boolean)object).booleanValue()) {
            object = locationModel.getBluetoothGPSName();
            object = this.getText() + "\n" + "Using device:  " + (String)object;
            this.setText((String)object);
        }
        this.a = locationModel;
        this.b = deviceScreen;
    }

    public void onCancel() {
        Log.debug("Canceling GPS initialization.");
        this.b.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceScreen doWork() {
        Object object = null;
        object = null;
        try {
            Object object2 = FindingGPSDevicesAlert.bluetoothLock;
            synchronized (object2) {
                object = this.a.getLocationProvider();
                if (object != null) {
                    ((LocationProvider)object).close();
                }
                object = this.a.getCriteria();
                object = LocationProvider.getInstance((Criteria)object);
            }
            this.a.setLocationProvider((LocationProvider)object);
            if (object != null) {
                object = new AcquiringLocationAlert(this.a, this.b);
            } else {
                Log.info("No location provider matched the criteria.");
                object = new ErrorAlert("GPS Error", "No location provider matched the criteria.", this.b);
            }
        }
        catch (LocationException locationException) {
            Log.error("All the location providers are currently out of service.", locationException);
            object = new ErrorAlert("GPS Error", "The GPS is already in use by another application.  Please shut it down and try again.", null);
        }
        catch (SecurityException securityException) {
            Log.error("The user blocked access to the location provider.", securityException);
            object = new ErrorAlert("GPS Error", "You must allow access for the application to work.\nPlease restart and allow all connections.", null);
        }
        catch (IOException iOException) {
            Log.error("An I/O error occured while connecting to the location provider.", iOException);
            object = "A problem occurred connecting to the GPS.\nExit the application and verify your phone's Bluetooth is on.  If it is please restart your phone and GPS device and try again.";
            object = new ErrorAlert("GPS Error", (String)object, null);
        }
        return object;
    }
}

