/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.examples.bluetoothgps;

import java.io.IOException;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.examples.bluetoothgps.LocationModel;
import org.j4me.examples.bluetoothgps.SelectGPSScreen;
import org.j4me.examples.ui.screens.ErrorAlert;
import org.j4me.examples.ui.screens.ProgressAlert;
import org.j4me.logging.Log;
import org.j4me.ui.DeviceScreen;

public class FindingGPSDevicesAlert
extends ProgressAlert {
    private final LocationModel a;
    protected static Object bluetoothLock = new Object();
    private final DeviceScreen b;

    public FindingGPSDevicesAlert(LocationModel locationModel, DeviceScreen deviceScreen) {
        super("Finding GPS...", "Looking for nearby Bluetooth devices.");
        this.a = locationModel;
        this.b = deviceScreen;
    }

    public void onCancel() {
        Log.info("Canceling Bluetooth device discovery.");
        this.b.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceScreen doWork() {
        String[][] stringArray = null;
        Object object = null;
        Object object2 = bluetoothLock;
        synchronized (object2) {
            Object object3;
            LocationProvider locationProvider = ((FindingGPSDevicesAlert)object3).a.getLocationProvider();
            if (locationProvider != null) {
                locationProvider.close();
            }
            try {
                Log.info("Discovering Bluetooth devices.");
                stringArray = LocationProvider.discoverBluetoothDevices();
                if (stringArray == null) {
                    Log.error("Problem with Bluetooh device discovery.  Operation returned null.");
                    object = "Bluetooth GPS device discovery failed.";
                }
            }
            catch (SecurityException securityException) {
                Log.error("User denied Bluetooth access.", securityException);
                object = "You must allow access for the GPS to work.\nPlease restart and allow all connections.";
            }
            catch (IOException iOException) {
                Log.error("Problem with Bluetooth device discovery.", iOException);
                object = "Bluetooth GPS device discovery failed.\nExit the application and verify your phone's Bluetooth is on.  If it is please restart your phone and GPS device and try again.";
            }
            if (object != null) {
                object3 = new ErrorAlert("Discovery Error", (String)object, ((FindingGPSDevicesAlert)object3).b);
            } else {
                Log.info("Found list of " + stringArray.length + " available devices and presenting them to the user.");
                object = new SelectGPSScreen(((FindingGPSDevicesAlert)object3).a, ((FindingGPSDevicesAlert)object3).b);
                ((SelectGPSScreen)object).setAvailableDevices(stringArray);
                if (stringArray.length == 0) {
                    object3 = "No devices were found.\nMake sure your Bluetooth GPS device is on and within 10 feet of you.";
                    object3 = new ErrorAlert("Discovery Error", (String)object3, (DeviceScreen)object);
                } else {
                    object3 = object;
                }
            }
            return object3;
        }
    }
}

