/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.collections;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.collections.Cache;
import org.j4me.collections.CacheTest$1;
import org.j4me.collections.CacheTest$2;
import org.j4me.collections.CacheTest$3;
import org.j4me.collections.CacheTest$4;
import org.j4me.collections.CacheTest$5;
import org.j4me.collections.CacheTest$6;
import org.j4me.collections.CacheTest$7;

public class CacheTest
extends TestCase {
    public CacheTest() {
    }

    public CacheTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new CacheTest("testBasicAddAndGet", new CacheTest$1(this)));
        testSuite.addTest(new CacheTest("testIllegalOperations", new CacheTest$2(this)));
        testSuite.addTest(new CacheTest("testAddingTwice", new CacheTest$3(this)));
        testSuite.addTest(new CacheTest("testLRU", new CacheTest$4(this)));
        testSuite.addTest(new CacheTest("testCapacityChange", new CacheTest$5(this)));
        testSuite.addTest(new CacheTest("testZeroCapacity", new CacheTest$6(this)));
        testSuite.addTest(new CacheTest("testCapacityOfOne", new CacheTest$7(this)));
        return testSuite;
    }

    public void testBasicAddAndGet() {
        Cache cache = new Cache(10);
        this.assertEquals("The maximum cache size should be set by the constructor.", 10L, cache.getMaxCapacity());
        this.assertEquals("The cache should initially be empty.", 0L, cache.size());
        Integer n = new Integer(42);
        cache.add(new Integer(13), n);
        this.assertEquals("Cache should not be empty now that an element has been added.", 1L, cache.size());
        Object object = cache.get(new Integer(13));
        this.assertTrue("The key should return a reference to the same object that was put in the cache.", n == object);
        object = cache.get(new Integer(12));
        this.assertNull("The key should not return data since it has not been added to the cache.", object);
        cache.clear();
        this.assertEquals("Cache should be empty now that it has been cleared.", 0L, cache.size());
        object = cache.get(new Integer(13));
        this.assertNull("Cache should not contain our key now that is has been cleared.", object);
    }

    public void testIllegalOperations() {
        Object object;
        boolean bl = false;
        try {
            new Cache(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        catch (Throwable throwable) {
            object = throwable;
            object = throwable.getClass().getName();
            this.fail("Expected exception 'IllegalArgumentException' and got '" + (String)object + "'.");
        }
        if (!bl) {
            this.fail("Expected exception 'IllegalArgumentException' but no exceptions caught.");
        }
        bl = false;
        try {
            object = new Cache(13);
            ((Cache)object).setMaxCapacity(-1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        catch (Throwable throwable) {
            object = throwable;
            object = throwable.getClass().getName();
            this.fail("Expected exception 'IllegalArgumentException' and got '" + (String)object + "'.");
        }
        if (!bl) {
            this.fail("Expected exception 'IllegalArgumentException' but no exceptions caught.");
        }
        bl = false;
        try {
            object = new Cache(5);
            ((Cache)object).add(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        catch (Throwable throwable) {
            object = throwable;
            object = throwable.getClass().getName();
            this.fail("Expected exception 'IllegalArgumentException' and got '" + (String)object + "'.");
        }
        if (!bl) {
            this.fail("Expected exception 'IllegalArgumentException' but no exceptions caught.");
        }
        bl = false;
        try {
            object = new Cache(5);
            ((Cache)object).add(new Integer(5), new Integer(5));
            ((Cache)object).get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        catch (Throwable throwable) {
            object = throwable;
            object = throwable.getClass().getName();
            this.fail("Expected exception 'IllegalArgumentException' and got '" + (String)object + "'.");
        }
        if (!bl) {
            this.fail("Expected exception 'IllegalArgumentException' but no exceptions caught.");
        }
    }

    public void testAddingTwice() {
        Integer n = new Integer(1);
        Integer n2 = new Integer(2);
        Cache cache = new Cache(5);
        for (int i = 0; i < 10; ++i) {
            cache.add(n, n);
        }
        this.assertEquals("one is the only element", 1L, cache.size());
        cache.add(n, n2);
        this.assertEquals("one is still the only element", 1L, cache.size());
        Integer n3 = (Integer)cache.get(n);
        this.assertEquals("data is two", n2, n3);
        cache.add(n2, n2);
        this.assertEquals("There are two elements", 2L, cache.size());
        n3 = (Integer)cache.get(n);
        this.assertEquals("key=one and data=two", n2, n3);
        n3 = (Integer)cache.get(n2);
        this.assertEquals("key=two and data=two", n2, n3);
    }

    public void testLRU() {
        Cache cache = new Cache(3);
        cache.add(new Integer(1), new Integer(1));
        cache.add(new Integer(2), new Integer(2));
        cache.add(new Integer(3), new Integer(3));
        this.assertEquals("Cache should be full.", 3, cache.size());
        cache.add(new Integer(4), new Integer(4));
        this.assertEquals("Cache should still be full.", 3, cache.size());
        Object object = cache.get(new Integer(1));
        this.assertNull("1 should no longer be in the cache (it was LRU).", object);
        object = cache.get(new Integer(2));
        this.assertNotNull("2 should still be in the cache.", object);
        object = cache.get(new Integer(3));
        this.assertNotNull("3 should still be in the cache.", object);
        object = cache.get(new Integer(4));
        this.assertNotNull("4 should be in the cache.", object);
        cache.get(new Integer(3));
        cache.get(new Integer(2));
        cache.add(new Integer(5), new Integer(5));
        cache.add(new Integer(6), new Integer(6));
        object = cache.get(new Integer(3));
        this.assertNull("3 should no longer be in the cache.", object);
        object = cache.get(new Integer(4));
        this.assertNull("4 should no longer be in the cache.", object);
        object = cache.get(new Integer(2));
        this.assertNotNull("2 should still be in the cache.", object);
        object = cache.get(new Integer(5));
        this.assertNotNull("5 should still be in the cache.", object);
        cache.add(new Integer(7), new Integer(7));
        object = cache.get(new Integer(2));
        this.assertNotNull("2, 5, and 7 should be in the cache.", object);
        object = cache.get(new Integer(5));
        this.assertNotNull("2, 5, and 7 should be in the cache.", object);
        object = cache.get(new Integer(7));
        this.assertNotNull("2, 5, and 7 should be in the cache.", object);
        cache.clear();
        object = cache.get(new Integer(2));
        this.assertNull("2, 5, and 7 should no longer be in the cache.", object);
        object = cache.get(new Integer(5));
        this.assertNull("2, 5, and 7 should no longer be in the cache.", object);
        object = cache.get(new Integer(7));
        this.assertNull("2, 5, and 7 should no longer be in the cache.", object);
        cache.add(new Integer(11), new Integer(11));
        cache.add(new Integer(12), new Integer(12));
        cache.add(new Integer(13), new Integer(13));
        cache.add(new Integer(14), new Integer(14));
        object = cache.get(new Integer(11));
        this.assertNull("11 should no longer be in the cache.", object);
        object = cache.get(new Integer(12));
        this.assertNotNull("12, 13, and 14 should be in the cache.", object);
        object = cache.get(new Integer(13));
        this.assertNotNull("12, 13, and 14 should be in the cache.", object);
        object = cache.get(new Integer(14));
        this.assertNotNull("12, 13, and 14 should be in the cache.", object);
    }

    public void testCapacityChange() {
        Cache cache = new Cache(3);
        cache.add(new Integer(1), new Integer(1));
        cache.add(new Integer(2), new Integer(2));
        cache.add(new Integer(3), new Integer(3));
        cache.setMaxCapacity(5);
        this.assertEquals("The cache capacity should have grown to 5.", 5L, cache.getMaxCapacity());
        cache.add(new Integer(4), new Integer(4));
        cache.add(new Integer(5), new Integer(5));
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(1)));
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(2)));
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(3)));
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(4)));
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(5)));
        cache.setMaxCapacity(5);
        this.assertEquals("The cache capacity should remain at 5.", 5L, cache.getMaxCapacity());
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(1)));
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(2)));
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(3)));
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(4)));
        this.assertNotNull("1, 2, 3, 4, and 5 should be in the cache.", cache.get(new Integer(5)));
        cache.setMaxCapacity(2);
        this.assertEquals("The cache capacity should shrink to 2.", 2L, cache.getMaxCapacity());
        this.assertEquals("The cache size should have shrunk to 2.", 2L, cache.size());
        this.assertNull("1, 2, 3 should not be in the cache.", cache.get(new Integer(1)));
        this.assertNull("1, 2, 3 should not be in the cache.", cache.get(new Integer(2)));
        this.assertNull("1, 2, 3 should not be in the cache.", cache.get(new Integer(3)));
        this.assertNotNull("4 and 5 should still be in the cache.", cache.get(new Integer(4)));
        this.assertNotNull("4 and 5 should still be in the cache.", cache.get(new Integer(5)));
    }

    public void testZeroCapacity() {
        Object object = new Integer(1);
        Cache cache = new Cache(0);
        this.assertEquals("Cache size is 0", 0L, cache.getMaxCapacity());
        cache.add(object, object);
        this.assertEquals("one not stored", 0L, cache.size());
        object = cache.get(object);
        this.assertNull("No data should be in cache", object);
    }

    public void testCapacityOfOne() {
        Integer n = new Integer(1);
        Integer n2 = new Integer(2);
        Cache cache = new Cache(1);
        this.assertEquals("Cache size is 1", 1L, cache.getMaxCapacity());
        cache.add(n, n);
        this.assertEquals("one stored", 1L, cache.size());
        Integer n3 = (Integer)cache.get(n);
        this.assertEquals("one's data", n, n3);
        cache.add(n2, n2);
        this.assertEquals("two only thing stored", 1L, cache.size());
        n3 = (Integer)cache.get(n);
        this.assertNull("one can no longer be retreived", n3);
        n3 = (Integer)cache.get(n2);
        this.assertEquals("two's data", n2, n3);
    }
}

