/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import j2meunit.framework.Test;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import org.j4me.J4METestCase;
import org.j4me.bluetoothgps.Coordinates;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.bluetoothgps.QualifiedCoordinatesTest$1;
import org.j4me.bluetoothgps.QualifiedCoordinatesTest$2;
import org.j4me.bluetoothgps.QualifiedCoordinatesTest$3;
import org.j4me.bluetoothgps.QualifiedCoordinatesTest$4;

public class QualifiedCoordinatesTest
extends J4METestCase {
    public QualifiedCoordinatesTest() {
    }

    public QualifiedCoordinatesTest(String string, TestMethod testMethod) {
        super(string, testMethod);
    }

    public Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new QualifiedCoordinatesTest("testGetSet", new QualifiedCoordinatesTest$1(this)));
        testSuite.addTest(new QualifiedCoordinatesTest("testToString", new QualifiedCoordinatesTest$2(this)));
        testSuite.addTest(new QualifiedCoordinatesTest("testDistance", new QualifiedCoordinatesTest$3(this)));
        testSuite.addTest(new QualifiedCoordinatesTest("testAzimuthTo", new QualifiedCoordinatesTest$4(this)));
        return testSuite;
    }

    public void testGetSet() {
        QualifiedCoordinates qualifiedCoordinates = new QualifiedCoordinates(37.345832, -120.832345, -7.1f, 1.8f, Float.NaN);
        this.assertEquals("Lattitude", 37.345832, qualifiedCoordinates.getLatitude(), 5.0E-7);
        this.assertEquals("Longitude", -120.832345, qualifiedCoordinates.getLongitude(), 5.0E-7);
        this.assertEquals("Elevation", -7.1f, qualifiedCoordinates.getAltitude(), 0.05);
        this.assertEquals("Horizontal accuracy", 1.8f, qualifiedCoordinates.getHorizontalAccuracy(), 0.05);
        this.assertTrue("Vertical accuracy", Float.isNaN(qualifiedCoordinates.getVerticalAccuracy()));
        qualifiedCoordinates.setLatitude(0.0);
        qualifiedCoordinates.setLongitude(84.17);
        qualifiedCoordinates.setAltitude(Float.NaN);
        qualifiedCoordinates.setHorizontalAccuracy(Float.NaN);
        qualifiedCoordinates.setVerticalAccuracy(12.3f);
        this.assertEquals("2 Lattitude", 0.0, qualifiedCoordinates.getLatitude(), 5.0E-7);
        this.assertEquals("2 Longitude", 84.17, qualifiedCoordinates.getLongitude(), 5.0E-7);
        this.assertTrue("2 Elevation", Float.isNaN(qualifiedCoordinates.getAltitude()));
        this.assertTrue("2 Horizontal accuracy", Float.isNaN(qualifiedCoordinates.getHorizontalAccuracy()));
        this.assertEquals("2 Vertical accuracy", 12.3f, qualifiedCoordinates.getVerticalAccuracy(), 0.05);
    }

    public void testToString() {
        Object object = new Coordinates(37.345832, -120.832345, -7.1f);
        this.assertTrue("Coordinates has latitude", ((String)(object = ((Coordinates)object).toString())).indexOf("37.345832") >= 0);
        this.assertTrue("Coordinates has latitude as north", ((String)object).indexOf("N") >= 0);
        this.assertTrue("Coordinates has longitude", ((String)object).indexOf("120.832345") >= 0);
        this.assertTrue("Coordinates has longitude as west", ((String)object).indexOf("W") >= 0);
        this.assertTrue("Coordinates has altitude", ((String)object).indexOf("-7.1") >= 0);
        QualifiedCoordinates qualifiedCoordinates = new QualifiedCoordinates(-73.448444, 55.382833, Float.NaN, Float.NaN, Float.NaN);
        object = qualifiedCoordinates.toString();
        this.assertTrue("QualifiedCoordinates has latitude", ((String)object).indexOf("73.448444") >= 0);
        this.assertTrue("QualifiedCoordinates has latitude as south", ((String)object).indexOf("S") >= 0);
        this.assertTrue("QualifiedCoordinates has longitude", ((String)object).indexOf("55.382833") >= 0);
        this.assertTrue("QualifiedCoordinates has longitude as east", ((String)object).indexOf("E") >= 0);
        qualifiedCoordinates.setHorizontalAccuracy(3.0f);
        qualifiedCoordinates.setAltitude(835.0f);
        qualifiedCoordinates.setVerticalAccuracy(1.7f);
        object = qualifiedCoordinates.toString();
        this.assertTrue("QualifiedCoordinates has horizontal accuracy", ((String)object).indexOf("3.0") >= 0);
        this.assertTrue("QualifiedCoordinates has vertical accuracy", ((String)object).indexOf("1.7") >= 0);
        qualifiedCoordinates = new QualifiedCoordinates(0.0, 0.0, Float.NaN, Float.NaN, Float.NaN);
        qualifiedCoordinates.toString();
    }

    public void testDistance() {
        Coordinates coordinates = new Coordinates(33.448444, 55.382833, Float.NaN);
        float f = coordinates.distance(coordinates);
        this.assertEquals("Distance to self is 0 meters", 0.0, f, 1.0E-7);
        Coordinates coordinates2 = new Coordinates(33.95, -118.4, Float.NaN);
        Coordinates coordinates3 = new Coordinates(40.63333333333333, -73.78333333333333, Float.NaN);
        double d = 3970688.0;
        f = coordinates2.distance(coordinates3);
        this.assertEquals("Distance in meters", d, f, 3000.0);
        f = coordinates3.distance(coordinates2);
        this.assertEquals("Reflexive test", d, f, 3000.0);
        coordinates2 = new Coordinates(53.150555555555556, -1.8444444444444446, Float.NaN);
        coordinates3 = new Coordinates(52.20472222222222, 0.14055555555555554, Float.NaN);
        f = coordinates2.distance(coordinates3);
        this.assertEquals("Distance in meters", 170200.0, f, 10.0);
        f = coordinates3.distance(coordinates2);
        this.assertEquals("Reflexive test", 170200.0, f, 10.0);
        Coordinates coordinates4 = new Coordinates(37.72468665475846, -122.49742881485966, Float.NaN);
        coordinates2 = new Coordinates(37.72574332138882, -122.49371100087049, Float.NaN);
        float f2 = coordinates4.distance(coordinates2);
        this.assertEquals("Distance in meters", 347.9799, f2, 1.0);
    }

    public void testAzimuthTo() {
        Coordinates coordinates = new Coordinates(33.95, -118.4, Float.NaN);
        Coordinates coordinates2 = new Coordinates(40.63333333333333, -73.78333333333333, Float.NaN);
        double d = 66.0;
        double d2 = coordinates.azimuthTo(coordinates2);
        this.assertEquals("Initial azimuth out of LAX to JFK", d, d2, 0.5);
    }
}

