/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.Coordinates;

public class QualifiedCoordinates
extends Coordinates {
    private float a;
    private float b;

    public QualifiedCoordinates(double d, double d2, float f, float f2, float f3) {
        super(d, d2, f);
        this.setHorizontalAccuracy(f2);
        this.setVerticalAccuracy(f3);
    }

    public float getHorizontalAccuracy() {
        return this.a;
    }

    public void setHorizontalAccuracy(float f) {
        if (Float.isNaN(f) || f >= 0.0f) {
            this.a = f;
            return;
        }
        throw new IllegalArgumentException("Horizontal accuracy (" + f + ") is invalid.");
    }

    public float getVerticalAccuracy() {
        return this.b;
    }

    public void setVerticalAccuracy(float f) {
        if (Float.isNaN(f) || f >= 0.0f) {
            this.b = f;
            return;
        }
        throw new IllegalArgumentException("Vertical accuracy (" + f + ") is invalid.");
    }

    public String toString() {
        String string = super.toString();
        if (!Float.isNaN(this.a)) {
            string = string + " \u00b1" + this.a + "mH";
        }
        if (!Float.isNaN(this.b)) {
            string = string + " \u00b1" + this.b + "mV";
        }
        return string;
    }
}

