/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationImpl;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.logging.Log;

public class MockLocationProvider
extends LocationProvider {
    private int a = 2;
    private LocationListener b;
    private Location c;

    public void setState(int n) {
        if (n != 3 && n != 2 && n != 1) {
            throw new IllegalArgumentException("state was invalid.  It must be OUT_OF_SERVICE, TEMPORARILY_UNAVAILABLE, or AVAILABLE.");
        }
        if (this.a != n) {
            this.a = n;
            if (this.b != null) {
                try {
                    this.b.providerStateChanged(this, n);
                    return;
                }
                catch (Throwable throwable) {
                    Log.warn("Unhandled exception in LocationProvider.providerStateChanged to " + n, throwable);
                }
            }
        }
    }

    public void setLocation(QualifiedCoordinates qualifiedCoordinates, float f) {
        if (qualifiedCoordinates == null) {
            throw new IllegalArgumentException("coordinates cannot be null.");
        }
        this.setState(1);
        if (this.b != null) {
            this.c = new LocationImpl(qualifiedCoordinates, f, Float.NaN, System.currentTimeMillis());
            try {
                this.b.locationUpdated(this, this.c);
                return;
            }
            catch (Throwable throwable) {
                Log.warn("Unhandled exception in LocationProvider.locationUpdated\n" + this.c, throwable);
            }
        }
    }

    public int getState() {
        return this.a;
    }

    public Location getLocation(int n) {
        if (this.a == 3) {
            throw new LocationException("Mock provider is out of service");
        }
        if (this.c == null) {
            throw new LocationException("Mock provider has not had location set yet");
        }
        return this.c;
    }

    protected Location getLastKnownLocationToProvider() {
        return this.c;
    }

    public void setLocationListener(LocationListener locationListener, int n, int n2, int n3) {
        this.b = locationListener;
    }

    public void reset() {
        this.setState(2);
        this.setState(1);
    }

    public void close() {
        this.setState(3);
        this.c = null;
    }
}

