/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.midletui;

import j2meunit.framework.AssertionFailedError;
import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestFailure;
import j2meunit.framework.TestListener;
import j2meunit.framework.TestResult;
import j2meunit.framework.TestSuite;
import j2meunit.midletui.TestRunner$1;
import j2meunit.util.StringUtil;
import j2meunit.util.Version;
import java.io.PrintStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class TestRunner
extends MIDlet
implements TestListener {
    protected static TestRunner theInstance = null;
    protected Gauge aProgressBar;
    protected List aResultsList;
    protected PrintStream aWriter = System.out;
    protected StringItem aErrorInfo;
    protected StringItem aFailureInfo;
    protected TestResult aResult;
    protected boolean bScreenOutput = true;
    protected boolean bTextOutput = true;
    protected int nCount;

    public TestRunner() {
        if (theInstance != null) {
            throw new RuntimeException("Only one MIDlet instance allowed!");
        }
        theInstance = this;
    }

    public static TestRunner getInstance() {
        return theInstance;
    }

    public void setOutputMode(boolean bl, boolean bl2) {
        this.bScreenOutput = bl;
        this.bTextOutput = bl2;
    }

    public void setWriter(PrintStream printStream) {
        this.aWriter = printStream;
    }

    public PrintStream getWriter() {
        return this.aWriter;
    }

    public synchronized void addError(Test test, Throwable throwable) {
        System.out.print("E");
    }

    public synchronized void addFailure(Test test, AssertionFailedError assertionFailedError) {
        System.out.print("F");
    }

    public void addToResultsList(String string) {
        if (this.bScreenOutput) {
            this.getResultsList().append(string, null);
        }
        if (this.bTextOutput) {
            this.aWriter.println(string);
        }
    }

    public void addToResultsList(Throwable throwable) {
        if (this.bScreenOutput) {
            String string = throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName();
            this.getResultsList().append(string, null);
        }
        if (this.bTextOutput) {
            throwable.printStackTrace();
        }
    }

    public void endTest(Test test) {
        if (this.aProgressBar != null) {
            this.aProgressBar.setValue(this.aProgressBar.getValue() + 1);
            this.aFailureInfo.setText(Integer.toString(this.aResult.failureCount()));
            this.aErrorInfo.setText(Integer.toString(this.aResult.errorCount()));
        }
    }

    public void endTestStep(Test test) {
        if (this.aProgressBar != null) {
            this.aProgressBar.setValue(this.aProgressBar.getValue() + 1);
        }
    }

    public synchronized void print(TestResult testResult) {
        this.printHeader(testResult);
        this.printErrors(testResult);
        this.printFailures(testResult);
        this.printFooter();
    }

    public void printErrors(TestResult object) {
        if (((TestResult)object).errorCount() != 0) {
            if (((TestResult)object).errorCount() == 1) {
                this.addToResultsList("There was " + ((TestResult)object).errorCount() + " error:");
            } else {
                this.addToResultsList("There were " + ((TestResult)object).errorCount() + " errors:");
            }
            int n = 1;
            object = ((TestResult)object).errors();
            while (object.hasMoreElements()) {
                TestFailure testFailure = (TestFailure)object.nextElement();
                this.addToResultsList(n + ") " + testFailure.failedTest());
                if (testFailure.thrownException() != null) {
                    this.addToResultsList(testFailure.thrownException());
                }
                ++n;
            }
        }
    }

    public void printFailures(TestResult object) {
        if (((TestResult)object).failureCount() != 0) {
            if (((TestResult)object).failureCount() == 1) {
                this.addToResultsList("There was " + ((TestResult)object).failureCount() + " failure:");
            } else {
                this.addToResultsList("There were " + ((TestResult)object).failureCount() + " failures:");
            }
            int n = 1;
            object = ((TestResult)object).failures();
            while (object.hasMoreElements()) {
                TestFailure testFailure = (TestFailure)object.nextElement();
                this.addToResultsList(n + ") " + testFailure.failedTest());
                if (testFailure.thrownException() != null) {
                    this.addToResultsList(testFailure.thrownException());
                }
                ++n;
            }
        }
    }

    public void printFooter() {
        this.addToResultsList("J2ME Unit " + Version.id());
        this.addToResultsList("Original Version by RoleModel Software, Inc.");
        this.addToResultsList("Original JUnit by Kent Beck and Erich Gamma");
    }

    public void printHeader(TestResult testResult) {
        if (testResult.wasSuccessful()) {
            this.addToResultsList("OK");
            this.addToResultsList(" (" + testResult.runCount() + " tests)");
            return;
        }
        this.addToResultsList("FAILURES");
        this.addToResultsList("Test Results:");
        this.addToResultsList("Run: " + testResult.runCount());
        this.addToResultsList("Failures: " + testResult.failureCount());
        this.addToResultsList("Errors: " + testResult.errorCount());
    }

    public void showResult() {
        if (this.bScreenOutput) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.getResultsList());
        }
    }

    public synchronized void startTest(Test test) {
        System.out.print(".");
    }

    protected List getResultsList() {
        if (this.aResultsList == null) {
            this.aResultsList = new List("J2ME Unit", 3);
        }
        return this.aResultsList;
    }

    protected Test createTestSuite(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage: TestRunner testCaseName1 [... testCaseNameN]");
            System.exit(-1);
        }
        TestSuite testSuite = new TestSuite();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = stringArray[i];
                object = (TestCase)Class.forName((String)object).newInstance();
                testSuite.addTest(((TestCase)object).suite());
                continue;
            }
            catch (Exception exception) {
                System.out.println("Access to TestCase " + stringArray[i] + " failed: " + exception.getMessage() + " - " + exception.getClass().getName());
            }
        }
        return testSuite;
    }

    protected void destroyApp(boolean bl) {
    }

    protected void doRun(Test test) {
        this.aResult = new TestResult();
        this.aResult.addListener(this);
        long l = System.currentTimeMillis();
        test.run(this.aResult);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.addToResultsList("Time: " + StringUtil.elapsedTimeAsString(l3));
        this.print(this.aResult);
    }

    protected void pauseApp() {
    }

    protected void start(String[] object) {
        object = this.createTestSuite((String[])object);
        Display display = Display.getDisplay((MIDlet)this);
        Form form = new Form("TestRunner");
        this.nCount = object.countTestSteps();
        this.aProgressBar = new Gauge(null, false, this.nCount, 0);
        this.aFailureInfo = new StringItem("Failures:", "0");
        this.aErrorInfo = new StringItem("Errors:", "0");
        form.append("Testing...");
        form.append((Item)this.aProgressBar);
        form.append((Item)this.aFailureInfo);
        form.append((Item)this.aErrorInfo);
        display.setCurrent((Displayable)form);
        new TestRunner$1(this, (Test)object).start();
    }

    protected void startApp() {
        try {
            String string = this.getAppProperty("J2MEUnitTestClasses");
            System.out.println("Testing: " + string);
            this.start(new String[]{string});
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception while setting up tests: " + exception);
            exception.printStackTrace();
            return;
        }
    }
}

