/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.framework;

import j2meunit.framework.AssertionFailedError;
import j2meunit.framework.Protectable;
import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestFailure;
import j2meunit.framework.TestListener;
import j2meunit.framework.TestResult$1;
import java.util.Enumeration;
import java.util.Vector;

public class TestResult {
    protected Vector fErrors;
    protected Vector fFailures = new Vector();
    protected Vector fListeners;
    protected int fAssertions;
    protected int fRunTests = 0;
    private boolean a = false;

    public TestResult() {
        this.fErrors = new Vector();
        this.fListeners = new Vector();
    }

    public void addError(Test test, Throwable throwable) {
        this.fErrors.addElement(new TestFailure(test, throwable));
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ((TestListener)this.fListeners.elementAt(i)).addError(test, throwable);
        }
    }

    public synchronized void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.fFailures.addElement(new TestFailure(test, assertionFailedError));
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ((TestListener)this.fListeners.elementAt(i)).addFailure(test, assertionFailedError);
        }
    }

    public synchronized void addListener(TestListener testListener) {
        this.fListeners.addElement(testListener);
    }

    public synchronized int assertionCount() {
        return this.fAssertions;
    }

    public synchronized void assertionMade() {
        ++this.fAssertions;
    }

    public void endTest(Test test) {
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ((TestListener)this.fListeners.elementAt(i)).endTest(test);
        }
    }

    public void endTestStep(Test test) {
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ((TestListener)this.fListeners.elementAt(i)).endTestStep(test);
        }
    }

    public synchronized int errorCount() {
        return this.fErrors.size();
    }

    public synchronized Enumeration errors() {
        return this.fErrors.elements();
    }

    public synchronized int failureCount() {
        return this.fFailures.size();
    }

    public synchronized Enumeration failures() {
        return this.fFailures.elements();
    }

    public synchronized int runCount() {
        return this.fRunTests;
    }

    public void runProtected(Test test, Protectable protectable) {
        try {
            protectable.protect();
            return;
        }
        catch (AssertionFailedError assertionFailedError) {
            this.addFailure(test, assertionFailedError);
            return;
        }
        catch (Throwable throwable) {
            this.addError(test, throwable);
            return;
        }
    }

    public synchronized int runTests() {
        return this.runCount();
    }

    public synchronized boolean shouldStop() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTest(Test test) {
        TestResult testResult = this;
        synchronized (testResult) {
            ++this.fRunTests;
        }
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ((TestListener)this.fListeners.elementAt(i)).startTest(test);
        }
    }

    public synchronized void stop() {
        this.a = true;
    }

    public synchronized int testErrors() {
        return this.errorCount();
    }

    public synchronized int testFailures() {
        return this.failureCount();
    }

    public synchronized boolean wasSuccessful() {
        return this.testFailures() == 0 && this.testErrors() == 0;
    }

    protected void run(TestCase testCase) {
        this.startTest(testCase);
        TestResult$1 testResult$1 = new TestResult$1(this, testCase);
        this.runProtected(testCase, testResult$1);
        this.endTest(testCase);
    }
}

